/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.GetTargetAttributeAction;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraftforge.registries.ForgeRegistries;

public class GetItemAttributesAction
extends GetTargetAttributeAction<ItemTarget> {
    protected String item;
    protected String amount;
    protected String damage;
    protected String compoundTag;

    public static Codec<GetItemAttributesAction> makeCodec(SpellActionType<GetItemAttributesAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(GetItemAttributesAction.activationCodec(), GetItemAttributesAction.sourceCodec(), (App)Codec.STRING.fieldOf(ParamNames.var("item")).forGetter(GetItemAttributesAction::getItem), (App)Codec.STRING.fieldOf(ParamNames.var("amount")).forGetter(GetItemAttributesAction::getAmount), (App)Codec.STRING.fieldOf(ParamNames.var("damage")).forGetter(GetItemAttributesAction::getDamage), (App)Codec.STRING.fieldOf(ParamNames.var("compound_tag")).forGetter(GetItemAttributesAction::getCompoundTag)).apply((Applicative)instance, (activation, source, item, amount, damage, compoundTag) -> new GetItemAttributesAction(type, (String)activation, (String)source, (String)item, (String)amount, (String)damage, (String)compoundTag)));
    }

    public static GetItemAttributesAction make(Object activation, Object source, String item, String amount, String damage, String compoundTag) {
        return new GetItemAttributesAction((SpellActionType)SpellActionTypes.GET_ITEM_ATTRIBUTES.get(), activation.toString(), source.toString(), item, amount, damage, compoundTag);
    }

    public GetItemAttributesAction(SpellActionType<?> type) {
        super(type);
    }

    public GetItemAttributesAction(SpellActionType<?> type, String activation, String source, String item, String amount, String damage, String compoundTag) {
        super(type, activation, source);
        this.item = item;
        this.amount = amount;
        this.damage = damage;
        this.compoundTag = compoundTag;
        if (!item.isEmpty()) {
            this.addVariableAttribute(i -> ForgeRegistries.ITEMS.getKey((Object)i.getItem().m_41720_()).toString(), (CtxVarType)CtxVarTypes.STRING.get(), item);
        }
        if (!amount.isEmpty()) {
            this.addVariableAttribute(i -> i.getItem().m_41613_(), (CtxVarType)CtxVarTypes.INT.get(), amount);
        }
        if (!damage.isEmpty()) {
            this.addVariableAttribute(i -> i.getItem().m_41773_(), (CtxVarType)CtxVarTypes.INT.get(), damage);
        }
        if (!compoundTag.isEmpty()) {
            this.addVariableAttribute(i -> i.getItem().m_41784_(), (CtxVarType)CtxVarTypes.TAG.get(), compoundTag);
        }
    }

    @Override
    public ITargetType<ItemTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ITEM.get();
    }

    public String getItem() {
        return this.item;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getDamage() {
        return this.damage;
    }

    public String getCompoundTag() {
        return this.compoundTag;
    }
}

