/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class GiveItemAction
extends AffectTypeAction<PlayerTarget> {
    protected DynamicCtxVar<Integer> amount;
    protected DynamicCtxVar<Integer> damage;
    protected DynamicCtxVar<CompoundTag> tag;
    protected DynamicCtxVar<String> item;

    public static Codec<GiveItemAction> makeCodec(SpellActionType<GiveItemAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(GiveItemAction.activationCodec(), GiveItemAction.multiTargetsCodec(), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("amount")).forGetter(GiveItemAction::getAmount), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("damage")).forGetter(GiveItemAction::getDamage), (App)((CtxVarType)CtxVarTypes.TAG.get()).refCodec().fieldOf(ParamNames.paramCompoundTag("tag")).forGetter(GiveItemAction::getTag), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf("item").forGetter(GiveItemAction::getItem)).apply((Applicative)instance, (activation, multiTargets, amount, damage, tag, item) -> new GiveItemAction(type, (String)activation, (String)multiTargets, (DynamicCtxVar<Integer>)amount, (DynamicCtxVar<Integer>)damage, (DynamicCtxVar<CompoundTag>)tag, (DynamicCtxVar<String>)item)));
    }

    public static GiveItemAction make(Object activation, Object multiTargets, DynamicCtxVar<Integer> amount, DynamicCtxVar<Integer> damage, DynamicCtxVar<CompoundTag> tag, DynamicCtxVar<String> item) {
        return new GiveItemAction((SpellActionType)SpellActionTypes.GIVE_ITEM.get(), activation.toString(), multiTargets.toString(), amount, damage, tag, item);
    }

    public GiveItemAction(SpellActionType<?> type) {
        super(type);
    }

    public GiveItemAction(SpellActionType<?> type, String activation, String multiTargets, DynamicCtxVar<Integer> amount, DynamicCtxVar<Integer> damage, DynamicCtxVar<CompoundTag> tag, DynamicCtxVar<String> item) {
        super(type, activation, multiTargets);
        this.amount = amount;
        this.damage = damage;
        this.tag = tag;
        this.item = item;
    }

    public DynamicCtxVar<Integer> getAmount() {
        return this.amount;
    }

    public DynamicCtxVar<Integer> getDamage() {
        return this.damage;
    }

    public DynamicCtxVar<CompoundTag> getTag() {
        return this.tag;
    }

    public DynamicCtxVar<String> getItem() {
        return this.item;
    }

    @Override
    public void affectTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        SpellsUtil.stringToObject(ctx, this.item, ForgeRegistries.ITEMS).ifPresent(item -> {
            ItemStack itemStack = new ItemStack((ItemLike)item);
            this.amount.getValue(ctx).ifPresent(amount -> {
                if (amount >= 0) {
                    itemStack.m_41764_(amount.intValue());
                }
            });
            if (itemStack.m_41619_()) {
                return;
            }
            this.damage.getValue(ctx).ifPresent(damage -> {
                if (damage >= 0) {
                    itemStack.m_41721_(damage.intValue());
                }
            });
            this.tag.getValue(ctx).ifPresent(arg_0 -> ((ItemStack)itemStack).m_41751_(arg_0));
            playerTarget.getPlayer().m_150109_().m_36054_(itemStack);
        });
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }
}

