/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemCheckAction
extends AffectSingleTypeAction<PlayerTarget> {
    protected DynamicCtxVar<Boolean> mustBeInHand;
    protected ItemStack item;

    public static Codec<ItemCheckAction> makeCodec(SpellActionType<ItemCheckAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ItemCheckAction.activationCodec(), ItemCheckAction.singleTargetCodec(), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("must_be_in_hand")).forGetter(ItemCheckAction::getMustBeInHand), (App)ItemStack.f_41582_.fieldOf("item").forGetter(ItemCheckAction::getItem)).apply((Applicative)instance, (activation, singleTarget, mustBeInHand, item) -> new ItemCheckAction(type, (String)activation, (String)singleTarget, (DynamicCtxVar<Boolean>)mustBeInHand, (ItemStack)item)));
    }

    public static ItemCheckAction make(Object activation, Object singleTarget, DynamicCtxVar<Boolean> mustBeInHand, ItemStack item) {
        return new ItemCheckAction((SpellActionType)SpellActionTypes.ITEM_CHECK.get(), activation.toString(), singleTarget.toString(), mustBeInHand, item);
    }

    public ItemCheckAction(SpellActionType<?> type) {
        super(type);
    }

    public ItemCheckAction(SpellActionType<?> type, String activation, String singleTarget, DynamicCtxVar<Boolean> mustBeInHand, ItemStack item) {
        super(type, activation, singleTarget);
        this.mustBeInHand = mustBeInHand;
        this.item = item;
    }

    public DynamicCtxVar<Boolean> getMustBeInHand() {
        return this.mustBeInHand;
    }

    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        this.mustBeInHand.getValue(ctx).ifPresent(mustBeInHand -> {
            Player player = playerTarget.getPlayer();
            if (mustBeInHand.booleanValue()) {
                for (ItemStack itemStack : player.m_6167_()) {
                    if (!itemStack.m_150930_(this.item.m_41720_()) || itemStack.m_41613_() < this.item.m_41613_() || !itemStack.areShareTagsEqual(this.item)) continue;
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(this.item.m_41613_());
                    }
                    return;
                }
                ctx.deactivate(this.activation);
            } else {
                if (player.m_7500_()) {
                    return;
                }
                for (ItemStack itemStack : player.m_150109_().f_35974_) {
                    if (!itemStack.m_150930_(this.item.m_41720_()) || itemStack.m_41613_() < this.item.m_41613_() || !itemStack.areShareTagsEqual(this.item)) continue;
                    itemStack.m_41774_(this.item.m_41613_());
                    return;
                }
                ItemStack itemStack = player.m_21206_();
                if (itemStack.m_150930_(this.item.m_41720_()) && itemStack.m_41613_() >= this.item.m_41613_() && itemStack.areShareTagsEqual(this.item)) {
                    itemStack.m_41774_(this.item.m_41613_());
                    return;
                }
                ctx.deactivate(this.activation);
            }
        });
    }
}

