/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.item.ItemStack;

public class ItemEqualsAction
extends AffectSingleTypeAction<ItemTarget> {
    protected ItemStack item;
    protected DynamicCtxVar<Boolean> ignoreTag;
    protected DynamicCtxVar<Integer> minimumCount;
    protected DynamicCtxVar<Integer> minimumDurability;

    public static Codec<ItemEqualsAction> makeCodec(SpellActionType<ItemEqualsAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ItemEqualsAction.activationCodec(), ItemEqualsAction.singleTargetCodec(), (App)ItemStack.f_41582_.fieldOf("item").forGetter(ItemEqualsAction::getItem), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("ignore_tag")).forGetter(ItemEqualsAction::getIgnoreTag), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("minimum_count")).forGetter(ItemEqualsAction::getMinimumCount), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("minimum_durability")).forGetter(ItemEqualsAction::getMinimumDurability)).apply((Applicative)instance, (activation, singleTarget, item, ignoreTag, minimumCount, minimumDurability) -> new ItemEqualsAction(type, (String)activation, (String)singleTarget, (ItemStack)item, (DynamicCtxVar<Boolean>)ignoreTag, (DynamicCtxVar<Integer>)minimumCount, (DynamicCtxVar<Integer>)minimumDurability)));
    }

    public static ItemEqualsAction make(Object activation, Object singleTarget, ItemStack item, DynamicCtxVar<Boolean> ignoreTag, DynamicCtxVar<Integer> minimumCount, DynamicCtxVar<Integer> minimumDurability) {
        return new ItemEqualsAction((SpellActionType)SpellActionTypes.ITEM_EQUALS.get(), activation.toString(), singleTarget.toString(), item, ignoreTag, minimumCount, minimumDurability);
    }

    public ItemEqualsAction(SpellActionType<?> type) {
        super(type);
    }

    public ItemEqualsAction(SpellActionType<?> type, String activation, String singleTarget, ItemStack item, DynamicCtxVar<Boolean> ignoreTag, DynamicCtxVar<Integer> minimumCount, DynamicCtxVar<Integer> minimumDurability) {
        super(type, activation, singleTarget);
        this.item = item;
        this.ignoreTag = ignoreTag;
        this.minimumCount = minimumCount;
        this.minimumDurability = minimumDurability;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public DynamicCtxVar<Boolean> getIgnoreTag() {
        return this.ignoreTag;
    }

    public DynamicCtxVar<Integer> getMinimumCount() {
        return this.minimumCount;
    }

    public DynamicCtxVar<Integer> getMinimumDurability() {
        return this.minimumDurability;
    }

    @Override
    public ITargetType<ItemTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ITEM.get();
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, ItemTarget itemTarget) {
        this.minimumCount.getValue(ctx).ifPresent(minimumCount -> this.minimumDurability.getValue(ctx).ifPresent(minimumDurability -> this.ignoreTag.getValue(ctx).ifPresent(ignoreTag -> {
            if (!itemTarget.getItem().m_150930_(this.item.m_41720_())) {
                ctx.deactivate(this.activation);
                return;
            }
            if (minimumCount >= 0 && itemTarget.getItem().m_41613_() < minimumCount) {
                ctx.deactivate(this.activation);
                return;
            }
            if (minimumDurability >= 0 && itemTarget.getItem().m_41776_() - itemTarget.getItem().m_41773_() < minimumDurability) {
                ctx.deactivate(this.activation);
                return;
            }
            if (!ignoreTag.booleanValue() && !ItemStack.m_41658_((ItemStack)this.item, (ItemStack)itemTarget.getItem())) {
                ctx.deactivate(this.activation);
            }
        })));
    }
}

