/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemTagCheckAction
extends AffectTypeAction<PlayerTarget> {
    protected DynamicCtxVar<Boolean> mustBeInHand;
    protected TagKey<Item> itemTag;
    protected DynamicCtxVar<Integer> count;

    public static Codec<ItemTagCheckAction> makeCodec(SpellActionType<ItemTagCheckAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ItemTagCheckAction.activationCodec(), ItemTagCheckAction.singleTargetCodec(), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("must_be_in_hand")).forGetter(ItemTagCheckAction::getMustBeInHand), (App)TagKey.m_203877_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey()).fieldOf("item_tag").forGetter(ItemTagCheckAction::getItemTag), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramBoolean("count")).forGetter(ItemTagCheckAction::getCount)).apply((Applicative)instance, (activation, target, mustBeInHand, itemTag, count) -> new ItemTagCheckAction(type, (String)activation, (String)target, (DynamicCtxVar<Boolean>)mustBeInHand, (TagKey<Item>)itemTag, (DynamicCtxVar<Integer>)count)));
    }

    public static ItemTagCheckAction make(Object activation, Object targets, DynamicCtxVar<Boolean> mustBeInHand, TagKey<Item> itemTag, DynamicCtxVar<Integer> count) {
        return new ItemTagCheckAction((SpellActionType)SpellActionTypes.ITEM_TAG_CHECK.get(), activation.toString(), targets.toString(), mustBeInHand, itemTag, count);
    }

    public ItemTagCheckAction(SpellActionType<?> type) {
        super(type);
    }

    public ItemTagCheckAction(SpellActionType<?> type, String activation, String targets, DynamicCtxVar<Boolean> mustBeInHand, TagKey<Item> itemTag, DynamicCtxVar<Integer> count) {
        super(type, activation, targets);
        this.mustBeInHand = mustBeInHand;
        this.itemTag = itemTag;
        this.count = count;
    }

    public DynamicCtxVar<Boolean> getMustBeInHand() {
        return this.mustBeInHand;
    }

    public TagKey<Item> getItemTag() {
        return this.itemTag;
    }

    public DynamicCtxVar<Integer> getCount() {
        return this.count;
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }

    @Override
    public void affectTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        this.mustBeInHand.getValue(ctx).ifPresent(mustBeInHand -> this.count.getValue(ctx).ifPresent(count -> {
            Player player = playerTarget.getPlayer();
            if (mustBeInHand.booleanValue()) {
                for (ItemStack itemStack : player.m_6167_()) {
                    if (!itemStack.m_204117_(this.itemTag) || itemStack.m_41613_() < count) continue;
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(count.intValue());
                    }
                    return;
                }
                ctx.deactivate(this.activation);
            } else {
                if (player.m_7500_()) {
                    return;
                }
                for (ItemStack itemStack : player.m_150109_().f_35974_) {
                    if (!itemStack.m_204117_(this.itemTag) || itemStack.m_41613_() < count) continue;
                    itemStack.m_41774_(count.intValue());
                    return;
                }
                ItemStack itemStack = player.m_21206_();
                if (itemStack.m_204117_(this.itemTag) && itemStack.m_41613_() >= count) {
                    itemStack.m_41774_(count.intValue());
                    return;
                }
                ctx.deactivate(this.activation);
            }
        }));
    }
}

