/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemTagEqualsAction
extends AffectSingleTypeAction<ItemTarget> {
    protected TagKey<Item> itemTag;
    protected DynamicCtxVar<Integer> minimumCount;
    protected DynamicCtxVar<Integer> minimumDurability;

    public static Codec<ItemTagEqualsAction> makeCodec(SpellActionType<ItemTagEqualsAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ItemTagEqualsAction.activationCodec(), ItemTagEqualsAction.singleTargetCodec(), (App)TagKey.m_203877_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey()).fieldOf("item_tag").forGetter(ItemTagEqualsAction::getItemTag), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("minimum_count")).forGetter(ItemTagEqualsAction::getMinimumCount), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("minimum_durability")).forGetter(ItemTagEqualsAction::getMinimumDurability)).apply((Applicative)instance, (activation, singleTarget, itemTag, minimumCount, minimumDurability) -> new ItemTagEqualsAction(type, (String)activation, (String)singleTarget, (TagKey<Item>)itemTag, (DynamicCtxVar<Integer>)minimumCount, (DynamicCtxVar<Integer>)minimumDurability)));
    }

    public static ItemTagEqualsAction make(Object activation, Object singleTarget, TagKey<Item> itemTag, DynamicCtxVar<Integer> minimumCount, DynamicCtxVar<Integer> minimumDurability) {
        return new ItemTagEqualsAction((SpellActionType)SpellActionTypes.ITEM_TAG_EQUALS.get(), activation.toString(), singleTarget.toString(), itemTag, minimumCount, minimumDurability);
    }

    public ItemTagEqualsAction(SpellActionType<?> type) {
        super(type);
    }

    public ItemTagEqualsAction(SpellActionType<?> type, String activation, String singleTarget, TagKey<Item> itemTag, DynamicCtxVar<Integer> minimumCount, DynamicCtxVar<Integer> minimumDurability) {
        super(type, activation, singleTarget);
        this.itemTag = itemTag;
        this.minimumCount = minimumCount;
        this.minimumDurability = minimumDurability;
    }

    public TagKey<Item> getItemTag() {
        return this.itemTag;
    }

    public DynamicCtxVar<Integer> getMinimumCount() {
        return this.minimumCount;
    }

    public DynamicCtxVar<Integer> getMinimumDurability() {
        return this.minimumDurability;
    }

    @Override
    public ITargetType<ItemTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ITEM.get();
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, ItemTarget itemTarget) {
        this.minimumCount.getValue(ctx).ifPresent(minimumCount -> this.minimumDurability.getValue(ctx).ifPresent(minimumDurability -> {
            if (!itemTarget.getItem().m_204117_(this.itemTag)) {
                ctx.deactivate(this.activation);
                return;
            }
            if (minimumCount >= 0 && itemTarget.getItem().m_41613_() < minimumCount) {
                ctx.deactivate(this.activation);
                return;
            }
            if (minimumDurability >= 0 && itemTarget.getItem().m_41776_() - itemTarget.getItem().m_41773_() < minimumDurability) {
                ctx.deactivate(this.activation);
            }
        }));
    }
}

