/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ModifyItemAction
extends AffectSingleTypeAction<ItemTarget> {
    protected DynamicCtxVar<Integer> amount;
    protected DynamicCtxVar<Integer> damage;
    protected DynamicCtxVar<CompoundTag> tag;

    public static Codec<ModifyItemAction> makeCodec(SpellActionType<ModifyItemAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ModifyItemAction.activationCodec(), ModifyItemAction.singleTargetCodec(), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("amount")).forGetter(ModifyItemAction::getAmount), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("damage")).forGetter(ModifyItemAction::getDamage), (App)((CtxVarType)CtxVarTypes.TAG.get()).refCodec().fieldOf(ParamNames.paramCompoundTag("tag")).forGetter(ModifyItemAction::getTag)).apply((Applicative)instance, (activation, singleTarget, amount, damage, tag) -> new ModifyItemAction(type, (String)activation, (String)singleTarget, (DynamicCtxVar<Integer>)amount, (DynamicCtxVar<Integer>)damage, (DynamicCtxVar<CompoundTag>)tag)));
    }

    public static ModifyItemAction make(Object activation, Object singleTarget, DynamicCtxVar<Integer> amount, DynamicCtxVar<Integer> damage, DynamicCtxVar<CompoundTag> tag) {
        return new ModifyItemAction((SpellActionType)SpellActionTypes.MODIFY_ITEM.get(), activation.toString(), singleTarget.toString(), amount, damage, tag);
    }

    public ModifyItemAction(SpellActionType<?> type) {
        super(type);
    }

    public ModifyItemAction(SpellActionType<?> type, String activation, String singleTarget, DynamicCtxVar<Integer> amount, DynamicCtxVar<Integer> damage, DynamicCtxVar<CompoundTag> tag) {
        super(type, activation, singleTarget);
        this.amount = amount;
        this.damage = damage;
        this.tag = tag;
    }

    public DynamicCtxVar<Integer> getAmount() {
        return this.amount;
    }

    public DynamicCtxVar<Integer> getDamage() {
        return this.damage;
    }

    public DynamicCtxVar<CompoundTag> getTag() {
        return this.tag;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, ItemTarget itemTarget) {
        ItemStack itemStack = itemTarget.getItem();
        this.amount.getValue(ctx).ifPresent(amount -> {
            if (amount >= 0) {
                itemStack.m_41764_(amount.intValue());
            }
        });
        this.damage.getValue(ctx).ifPresent(damage -> {
            if (damage >= 0) {
                itemStack.m_41721_(damage.intValue());
            }
        });
        this.tag.getValue(ctx).ifPresent(arg_0 -> ((ItemStack)itemStack).m_41751_(arg_0));
    }

    @Override
    public ITargetType<ItemTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ITEM.get();
    }
}

