/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class OverrideItemAction
extends AffectSingleTypeAction<ItemTarget> {
    protected DynamicCtxVar<Integer> amount;
    protected DynamicCtxVar<Integer> damage;
    protected DynamicCtxVar<CompoundTag> tag;
    protected DynamicCtxVar<String> item;

    public static Codec<OverrideItemAction> makeCodec(SpellActionType<OverrideItemAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(OverrideItemAction.activationCodec(), OverrideItemAction.singleTargetCodec(), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("amount")).forGetter(OverrideItemAction::getAmount), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("damage")).forGetter(OverrideItemAction::getDamage), (App)((CtxVarType)CtxVarTypes.TAG.get()).refCodec().fieldOf(ParamNames.paramCompoundTag("tag")).forGetter(OverrideItemAction::getTag), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf(ParamNames.paramString("item")).forGetter(OverrideItemAction::getItem)).apply((Applicative)instance, (activation, singleTarget, amount, damage, tag, item) -> new OverrideItemAction(type, (String)activation, (String)singleTarget, (DynamicCtxVar<Integer>)amount, (DynamicCtxVar<Integer>)damage, (DynamicCtxVar<CompoundTag>)tag, (DynamicCtxVar<String>)item)));
    }

    public static OverrideItemAction make(Object activation, Object singleTarget, DynamicCtxVar<Integer> amount, DynamicCtxVar<Integer> damage, DynamicCtxVar<CompoundTag> tag, DynamicCtxVar<String> item) {
        return new OverrideItemAction((SpellActionType)SpellActionTypes.OVERRIDE_ITEM.get(), activation.toString(), singleTarget.toString(), amount, damage, tag, item);
    }

    public OverrideItemAction(SpellActionType<?> type) {
        super(type);
    }

    public OverrideItemAction(SpellActionType<?> type, String activation, String singleTarget, DynamicCtxVar<Integer> amount, DynamicCtxVar<Integer> damage, DynamicCtxVar<CompoundTag> tag, DynamicCtxVar<String> item) {
        super(type, activation, singleTarget);
        this.amount = amount;
        this.damage = damage;
        this.tag = tag;
        this.item = item;
    }

    public DynamicCtxVar<Integer> getAmount() {
        return this.amount;
    }

    public DynamicCtxVar<Integer> getDamage() {
        return this.damage;
    }

    public DynamicCtxVar<CompoundTag> getTag() {
        return this.tag;
    }

    public DynamicCtxVar<String> getItem() {
        return this.item;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, ItemTarget itemTarget) {
        SpellsUtil.stringToObject(ctx, this.item, ForgeRegistries.ITEMS).ifPresent(item -> {
            ItemStack newStack = new ItemStack((ItemLike)item);
            this.amount.getValue(ctx).ifPresent(amount -> {
                if (amount >= 0) {
                    newStack.m_41764_(amount.intValue());
                }
            });
            if (newStack.m_41619_()) {
                return;
            }
            this.damage.getValue(ctx).ifPresent(damage -> {
                if (damage >= 0) {
                    newStack.m_41721_(damage.intValue());
                }
            });
            this.tag.getValue(ctx).ifPresent(arg_0 -> ((ItemStack)newStack).m_41751_(arg_0));
            itemTarget.modify(newStack);
        });
    }

    @Override
    public ITargetType<ItemTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ITEM.get();
    }
}

