/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayerHasItemsAction
extends AffectSingleTypeAction<PlayerTarget> {
    protected DynamicCtxVar<String> item;
    protected DynamicCtxVar<Integer> amount;
    protected DynamicCtxVar<CompoundTag> tag;
    protected DynamicCtxVar<Boolean> mustBeInHand;
    protected DynamicCtxVar<Boolean> creativeBypass;

    public static Codec<PlayerHasItemsAction> makeCodec(SpellActionType<PlayerHasItemsAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(PlayerHasItemsAction.activationCodec(), PlayerHasItemsAction.sourceCodec(), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf(ParamNames.paramString("item")).forGetter(PlayerHasItemsAction::getItem), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("amount")).forGetter(PlayerHasItemsAction::getAmount), (App)((CtxVarType)CtxVarTypes.TAG.get()).refCodec().fieldOf(ParamNames.paramCompoundTag("tag")).forGetter(PlayerHasItemsAction::getTag), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("must_be_in_hand")).forGetter(PlayerHasItemsAction::getMustBeInHand), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("creative_bypass")).forGetter(PlayerHasItemsAction::getCreativeBypass)).apply((Applicative)instance, (activation, source, item, amount, tag, mustBeInHand, creativeBypass) -> new PlayerHasItemsAction(type, (String)activation, (String)source, (DynamicCtxVar<String>)item, (DynamicCtxVar<Integer>)amount, (DynamicCtxVar<CompoundTag>)tag, (DynamicCtxVar<Boolean>)mustBeInHand, (DynamicCtxVar<Boolean>)creativeBypass)));
    }

    public static PlayerHasItemsAction make(Object activation, Object source, DynamicCtxVar<String> item, DynamicCtxVar<Integer> amount, DynamicCtxVar<CompoundTag> tag, DynamicCtxVar<Boolean> mustBeInHand, DynamicCtxVar<Boolean> creativeBypass) {
        return new PlayerHasItemsAction((SpellActionType)SpellActionTypes.PLAYER_HAS_ITEMS.get(), activation.toString(), source.toString(), item, amount, tag, mustBeInHand, creativeBypass);
    }

    public PlayerHasItemsAction(SpellActionType<?> type) {
        super(type);
    }

    public PlayerHasItemsAction(SpellActionType<?> type, String activation, String source, DynamicCtxVar<String> item, DynamicCtxVar<Integer> amount, DynamicCtxVar<CompoundTag> tag, DynamicCtxVar<Boolean> mustBeInHand, DynamicCtxVar<Boolean> creativeBypass) {
        super(type, activation, source);
        this.item = item;
        this.amount = amount;
        this.tag = tag;
        this.mustBeInHand = mustBeInHand;
        this.creativeBypass = creativeBypass;
    }

    public DynamicCtxVar<String> getItem() {
        return this.item;
    }

    public DynamicCtxVar<Integer> getAmount() {
        return this.amount;
    }

    public DynamicCtxVar<CompoundTag> getTag() {
        return this.tag;
    }

    public DynamicCtxVar<Boolean> getMustBeInHand() {
        return this.mustBeInHand;
    }

    public DynamicCtxVar<Boolean> getCreativeBypass() {
        return this.creativeBypass;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        SpellsUtil.stringToObject(ctx, this.item, ForgeRegistries.ITEMS).ifPresent(item -> this.amount.getValue(ctx).ifPresent(amount -> this.mustBeInHand.getValue(ctx).ifPresent(mustBeInHand -> this.creativeBypass.getValue(ctx).ifPresent(creativeBypass -> {
            List<ItemStack> items;
            Player player = playerTarget.getPlayer();
            if (creativeBypass.booleanValue() && player.m_7500_()) {
                return;
            }
            if (mustBeInHand.booleanValue()) {
                items = List.of(player.m_21205_(), player.m_21206_());
            } else {
                items = new ArrayList<ItemStack>(player.m_150109_().f_35974_.size());
                items.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
                items.addAll((Collection<ItemStack>)player.m_150109_().f_35976_);
            }
            CompoundTag tag = this.tag.getValue(ctx).orElse(null);
            int count = 0;
            for (ItemStack i : items) {
                if (i.m_41720_() == item && (tag == null || tag.m_128456_() || i.m_41783_() != null && tag.equals((Object)i.m_41783_()))) {
                    count += i.m_41613_();
                }
                if (count < amount) continue;
                return;
            }
            ctx.deactivate(this.activation);
        }))));
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }
}

