/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerItemTargetsAction
extends AffectSingleTypeAction<PlayerTarget> {
    protected String dst;
    protected DynamicCtxVar<Boolean> includeHands;
    protected DynamicCtxVar<Boolean> includeInventory;
    protected DynamicCtxVar<Boolean> includeArmor;

    public static Codec<PlayerItemTargetsAction> makeCodec(SpellActionType<PlayerItemTargetsAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(PlayerItemTargetsAction.activationCodec(), PlayerItemTargetsAction.sourceCodec(), (App)Codec.STRING.fieldOf(ParamNames.destinationTarget("items")).forGetter(PlayerItemTargetsAction::getDst), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("include_hands")).forGetter(PlayerItemTargetsAction::getIncludeHands), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("include_inventory")).forGetter(PlayerItemTargetsAction::getIncludeInventory), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("include_armor")).forGetter(PlayerItemTargetsAction::getIncludeArmor)).apply((Applicative)instance, (activation, source, dst, includeHands, includeInventory, includeArmor) -> new PlayerItemTargetsAction(type, (String)activation, (String)source, (String)dst, (DynamicCtxVar<Boolean>)includeHands, (DynamicCtxVar<Boolean>)includeInventory, (DynamicCtxVar<Boolean>)includeArmor)));
    }

    public static PlayerItemTargetsAction make(Object activation, Object source, String dst, DynamicCtxVar<Boolean> includeHands, DynamicCtxVar<Boolean> includeInventory, DynamicCtxVar<Boolean> includeArmor) {
        return new PlayerItemTargetsAction((SpellActionType)SpellActionTypes.PLAYER_ITEM_TARGETS.get(), activation.toString(), source.toString(), dst, includeHands, includeInventory, includeArmor);
    }

    public PlayerItemTargetsAction(SpellActionType<?> type) {
        super(type);
    }

    public PlayerItemTargetsAction(SpellActionType<?> type, String activation, String source, String dst, DynamicCtxVar<Boolean> includeHands, DynamicCtxVar<Boolean> includeInventory, DynamicCtxVar<Boolean> includeArmor) {
        super(type, activation, source);
        this.dst = dst;
        this.includeHands = includeHands;
        this.includeInventory = includeInventory;
        this.includeArmor = includeArmor;
    }

    public String getDst() {
        return this.dst;
    }

    public DynamicCtxVar<Boolean> getIncludeHands() {
        return this.includeHands;
    }

    public DynamicCtxVar<Boolean> getIncludeInventory() {
        return this.includeInventory;
    }

    public DynamicCtxVar<Boolean> getIncludeArmor() {
        return this.includeArmor;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        int finalI;
        int i2;
        Player player = playerTarget.getPlayer();
        TargetGroup items = ctx.getOrCreateTargetGroup(this.dst);
        boolean hands = this.includeHands.getValue(ctx).orElse(false);
        boolean inventory = this.includeInventory.getValue(ctx).orElse(false);
        boolean armor = this.includeArmor.getValue(ctx).orElse(false);
        if (hands) {
            items.addTargets((Target)Target.of(player.f_19853_, player.m_21205_(), i -> player.m_21008_(InteractionHand.MAIN_HAND, i), player.m_7500_()));
            items.addTargets((Target)Target.of(player.f_19853_, player.m_21206_(), i -> player.m_21008_(InteractionHand.OFF_HAND, i), player.m_7500_()));
        }
        if (inventory) {
            for (i2 = 0; i2 < player.m_150109_().f_35974_.size(); ++i2) {
                if (i2 == player.m_150109_().f_35977_) continue;
                finalI = i2;
                items.addTargets((Target)Target.of(player.f_19853_, (ItemStack)player.m_150109_().f_35974_.get(i2), j -> player.m_150109_().f_35974_.set(finalI, j), player.m_7500_()));
            }
        }
        if (armor) {
            for (i2 = 0; i2 < player.m_150109_().f_35975_.size(); ++i2) {
                if (i2 == player.m_150109_().f_35977_) continue;
                finalI = i2;
                items.addTargets((Target)Target.of(player.f_19853_, (ItemStack)player.m_150109_().f_35975_.get(i2), j -> player.m_150109_().f_35975_.set(finalI, j), player.m_7500_()));
            }
        }
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }
}

