/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;

public class TryConsumeItemAction
extends AffectSingleTypeAction<ItemTarget> {
    protected DynamicCtxVar<Integer> amount;

    public static Codec<TryConsumeItemAction> makeCodec(SpellActionType<TryConsumeItemAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(TryConsumeItemAction.activationCodec(), TryConsumeItemAction.singleTargetCodec(), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("amount")).forGetter(TryConsumeItemAction::getAmount)).apply((Applicative)instance, (activation, singleTarget, amount) -> new TryConsumeItemAction(type, (String)activation, (String)singleTarget, (DynamicCtxVar<Integer>)amount)));
    }

    public static TryConsumeItemAction make(Object activation, Object singleTarget, DynamicCtxVar<Integer> damage) {
        return new TryConsumeItemAction((SpellActionType)SpellActionTypes.TRY_CONSUME_ITEM.get(), activation.toString(), singleTarget.toString(), damage);
    }

    public TryConsumeItemAction(SpellActionType<?> type) {
        super(type);
    }

    public TryConsumeItemAction(SpellActionType<?> type, String activation, String singleTarget, DynamicCtxVar<Integer> amount) {
        super(type, activation, singleTarget);
        this.amount = amount;
    }

    public DynamicCtxVar<Integer> getAmount() {
        return this.amount;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, ItemTarget itemTarget) {
        this.amount.getValue(ctx).ifPresent(amount -> {
            if (itemTarget.getItem().m_41613_() < amount) {
                ctx.deactivate(this.activation);
                return;
            }
            if (!itemTarget.isCreative()) {
                itemTarget.getItem().m_41774_(amount.intValue());
            }
        });
    }

    @Override
    public ITargetType<ItemTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ITEM.get();
    }
}

