/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;

public class TryDamageItemAction
extends AffectSingleTypeAction<ItemTarget> {
    protected DynamicCtxVar<Integer> damage;

    public static Codec<TryDamageItemAction> makeCodec(SpellActionType<TryDamageItemAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(TryDamageItemAction.activationCodec(), TryDamageItemAction.singleTargetCodec(), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("damage")).forGetter(TryDamageItemAction::getDamage)).apply((Applicative)instance, (activation, singleTarget, damage) -> new TryDamageItemAction(type, (String)activation, (String)singleTarget, (DynamicCtxVar<Integer>)damage)));
    }

    public static TryDamageItemAction make(Object activation, Object singleTarget, DynamicCtxVar<Integer> damage) {
        return new TryDamageItemAction((SpellActionType)SpellActionTypes.TRY_DAMAGE_ITEM.get(), activation.toString(), singleTarget.toString(), damage);
    }

    public TryDamageItemAction(SpellActionType<?> type) {
        super(type);
    }

    public TryDamageItemAction(SpellActionType<?> type, String activation, String singleTarget, DynamicCtxVar<Integer> damage) {
        super(type, activation, singleTarget);
        this.damage = damage;
    }

    public DynamicCtxVar<Integer> getDamage() {
        return this.damage;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, ItemTarget itemTarget) {
        this.damage.getValue(ctx).ifPresent(damage -> {
            if (itemTarget.getItem().m_41776_() - itemTarget.getItem().m_41773_() < damage) {
                ctx.deactivate(this.activation);
                return;
            }
            if (!itemTarget.isCreative()) {
                itemTarget.getItem().m_220157_(damage.intValue(), SpellsUtil.RANDOM, null);
            }
        });
    }

    @Override
    public ITargetType<ItemTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ITEM.get();
    }
}

