/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class UseItemAction
extends AffectSingleTypeAction<PlayerTarget> {
    protected ItemStack item;
    protected boolean offhand;

    public static Codec<UseItemAction> makeCodec(SpellActionType<UseItemAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(UseItemAction.activationCodec(), UseItemAction.sourceCodec(), (App)ItemStack.f_41582_.fieldOf("item").forGetter(UseItemAction::getItem), (App)Codec.BOOL.fieldOf("offhand").forGetter(UseItemAction::getOffhand)).apply((Applicative)instance, (activation, source, item, offhand) -> new UseItemAction(type, (String)activation, (String)source, (ItemStack)item, (boolean)offhand)));
    }

    public static UseItemAction make(Object activation, Object source, ItemStack item, boolean offhand) {
        return new UseItemAction((SpellActionType)SpellActionTypes.USE_ITEM.get(), activation.toString(), source.toString(), item, offhand);
    }

    public UseItemAction(SpellActionType<?> type) {
        super(type);
    }

    public UseItemAction(SpellActionType<?> type, String activation, String source, ItemStack item, boolean offhand) {
        super(type, activation, source);
        this.item = item;
        this.offhand = offhand;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean getOffhand() {
        return this.offhand;
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        ItemStack item = this.item.m_41777_();
        item.m_41682_(ctx.level, playerTarget.getPlayer(), this.offhand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
    }
}

