/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;

public class UseItemOnBlocksAction
extends AffectSingleTypeAction<PlayerTarget> {
    protected String blocks;
    protected ItemStack item;
    protected boolean offhand;
    protected Direction direction;

    public static Codec<UseItemOnBlocksAction> makeCodec(SpellActionType<UseItemOnBlocksAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(UseItemOnBlocksAction.activationCodec(), UseItemOnBlocksAction.sourceCodec(), (App)Codec.STRING.fieldOf(ParamNames.multiTarget("blocks")).forGetter(UseItemOnBlocksAction::getBlocks), (App)ItemStack.f_41582_.fieldOf("item").forGetter(UseItemOnBlocksAction::getItem), (App)Codec.BOOL.fieldOf("offhand").forGetter(UseItemOnBlocksAction::getOffhand), (App)SpellsUtil.namedEnumCodec(Direction::m_122402_, Direction::m_122433_).fieldOf("direction").forGetter(UseItemOnBlocksAction::getDirection)).apply((Applicative)instance, (activation, source, blocks, item, offhand, direction) -> new UseItemOnBlocksAction(type, (String)activation, (String)source, (String)blocks, (ItemStack)item, (boolean)offhand, (Direction)direction)));
    }

    public static UseItemOnBlocksAction make(Object activation, Object source, String blocks, ItemStack item, boolean offhand, Direction direction) {
        return new UseItemOnBlocksAction((SpellActionType)SpellActionTypes.USE_ITEM_ON_BLOCK.get(), activation.toString(), source.toString(), blocks, item, offhand, direction);
    }

    public UseItemOnBlocksAction(SpellActionType<?> type) {
        super(type);
    }

    public UseItemOnBlocksAction(SpellActionType<?> type, String activation, String source, String blocks, ItemStack item, boolean offhand, Direction direction) {
        super(type, activation, source);
        this.blocks = blocks;
        this.item = item;
        this.offhand = offhand;
        this.direction = direction;
    }

    public String getBlocks() {
        return this.blocks;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean getOffhand() {
        return this.offhand;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        ctx.getTargetGroup(this.blocks).forEachTarget(t -> ((ITargetType)TargetTypes.POSITION.get()).ifType((Target)t, positionTarget -> {
            ItemStack item = this.item.m_41777_();
            item.m_41661_(new UseOnContext(ctx.level, null, this.offhand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, item, new BlockHitResult(positionTarget.getPosition(), this.direction, positionTarget.getBlockPos(), false)));
        }));
    }
}

