/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PositionTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class GetBlockAction
extends AffectSingleTypeAction<PositionTarget> {
    protected String block;
    protected String blockState;
    protected String isAir;

    public static Codec<GetBlockAction> makeCodec(SpellActionType<GetBlockAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(GetBlockAction.activationCodec(), GetBlockAction.singleTargetCodec(), (App)Codec.STRING.fieldOf(ParamNames.var("block")).forGetter(GetBlockAction::getBlock), (App)Codec.STRING.fieldOf(ParamNames.var("block_state")).forGetter(GetBlockAction::getBlockState), (App)Codec.STRING.fieldOf(ParamNames.var("is_air")).forGetter(GetBlockAction::getIsAir)).apply((Applicative)instance, (activation, singleTarget, block, blockState, isAir) -> new GetBlockAction(type, (String)activation, (String)singleTarget, (String)block, (String)blockState, (String)isAir)));
    }

    public static GetBlockAction make(Object activation, Object singleTarget, String block, String blockState, String isAir) {
        return new GetBlockAction((SpellActionType)SpellActionTypes.GET_BLOCK.get(), activation.toString(), singleTarget.toString(), block, blockState, isAir);
    }

    public GetBlockAction(SpellActionType<?> type) {
        super(type);
    }

    public GetBlockAction(SpellActionType<?> type, String activation, String singleTarget, String block, String blockState, String isAir) {
        super(type, activation, singleTarget);
        this.block = block;
        this.blockState = blockState;
        this.isAir = isAir;
    }

    public String getBlock() {
        return this.block;
    }

    public String getBlockState() {
        return this.blockState;
    }

    public String getIsAir() {
        return this.isAir;
    }

    @Override
    public ITargetType<PositionTarget> getAffectedType() {
        return (ITargetType)TargetTypes.POSITION.get();
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PositionTarget positionTarget) {
        BlockState blockState = ctx.level.m_8055_(positionTarget.getBlockPos());
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
        if (id == null) {
            return;
        }
        if (!blockState.m_60795_()) {
            ctx.setCtxVar((CtxVarType)CtxVarTypes.TAG.get(), this.blockState, SpellsUtil.stateToTag(blockState));
        }
        ctx.setCtxVar((CtxVarType)CtxVarTypes.STRING.get(), this.block, id.toString());
        ctx.setCtxVar((CtxVarType)CtxVarTypes.BOOLEAN.get(), this.isAir, blockState.m_60795_());
    }
}

