/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PositionTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class GetBlockAttributesAction
extends AffectSingleTypeAction<PositionTarget> {
    protected String isAir;
    protected String isFluid;
    protected String hasCollider;

    public static Codec<GetBlockAttributesAction> makeCodec(SpellActionType<GetBlockAttributesAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(GetBlockAttributesAction.activationCodec(), GetBlockAttributesAction.singleTargetCodec(), (App)Codec.STRING.fieldOf(ParamNames.var("is_air")).forGetter(GetBlockAttributesAction::getIsAir), (App)Codec.STRING.fieldOf(ParamNames.var("is_fluid")).forGetter(GetBlockAttributesAction::getIsFluid), (App)Codec.STRING.fieldOf(ParamNames.var("has_collider")).forGetter(GetBlockAttributesAction::getHasCollider)).apply((Applicative)instance, (activation, singleTarget, isAir, isFluid, hasCollider) -> new GetBlockAttributesAction(type, (String)activation, (String)singleTarget, (String)isAir, (String)isFluid, (String)hasCollider)));
    }

    public static GetBlockAttributesAction make(Object activation, Object singleTarget, String isAir, String isFluid, String hasCollider) {
        return new GetBlockAttributesAction((SpellActionType)SpellActionTypes.GET_BLOCK_ATTRIBUTES.get(), activation.toString(), singleTarget.toString(), isAir, isFluid, hasCollider);
    }

    public GetBlockAttributesAction(SpellActionType<?> type) {
        super(type);
    }

    public GetBlockAttributesAction(SpellActionType<?> type, String activation, String singleTarget, String isAir, String isFluid, String hasCollider) {
        super(type, activation, singleTarget);
        this.isAir = isAir;
        this.isFluid = isFluid;
        this.hasCollider = hasCollider;
    }

    public String getIsAir() {
        return this.isAir;
    }

    public String getIsFluid() {
        return this.isFluid;
    }

    public String getHasCollider() {
        return this.hasCollider;
    }

    @Override
    public ITargetType<PositionTarget> getAffectedType() {
        return (ITargetType)TargetTypes.POSITION.get();
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PositionTarget positionTarget) {
        BlockState blockState = ctx.level.m_8055_(positionTarget.getBlockPos());
        FluidState fluidState = blockState.m_60819_();
        ctx.setCtxVar((CtxVarType)CtxVarTypes.BOOLEAN.get(), this.isAir, blockState.m_60795_());
        ctx.setCtxVar((CtxVarType)CtxVarTypes.BOOLEAN.get(), this.isFluid, !fluidState.m_76178_());
        ctx.setCtxVar((CtxVarType)CtxVarTypes.BOOLEAN.get(), this.hasCollider, !blockState.m_60812_((BlockGetter)ctx.level, positionTarget.getBlockPos()).m_83281_());
    }
}

