/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PositionTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class GetFluidAction
extends AffectSingleTypeAction<PositionTarget> {
    protected String fluid;
    protected String fluidState;
    protected String isFluid;
    protected String isSource;

    public static Codec<GetFluidAction> makeCodec(SpellActionType<GetFluidAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(GetFluidAction.activationCodec(), GetFluidAction.singleTargetCodec(), (App)Codec.STRING.fieldOf(ParamNames.var("fluid")).forGetter(GetFluidAction::getFluid), (App)Codec.STRING.fieldOf(ParamNames.var("fluid_state")).forGetter(GetFluidAction::getFluidState), (App)Codec.STRING.fieldOf(ParamNames.var("is_fluid")).forGetter(GetFluidAction::getIsFluid), (App)Codec.STRING.fieldOf(ParamNames.var("is_source")).forGetter(GetFluidAction::getIsSource)).apply((Applicative)instance, (activation, singleTarget, fluid, fluidState, isFluid, isSource) -> new GetFluidAction(type, (String)activation, (String)singleTarget, (String)fluid, (String)fluidState, (String)isFluid, (String)isSource)));
    }

    public static GetFluidAction make(Object activation, Object singleTarget, String fluid, String fluidState, String isFluid, String isSource) {
        return new GetFluidAction((SpellActionType)SpellActionTypes.GET_FLUID.get(), activation.toString(), singleTarget.toString(), fluid, fluidState, isFluid, isSource);
    }

    public GetFluidAction(SpellActionType<?> type) {
        super(type);
    }

    public GetFluidAction(SpellActionType<?> type, String activation, String singleTarget, String fluid, String fluidState, String isFluid, String isSource) {
        super(type, activation, singleTarget);
        this.fluid = fluid;
        this.fluidState = fluidState;
        this.isFluid = isFluid;
        this.isSource = isSource;
    }

    public String getFluid() {
        return this.fluid;
    }

    public String getFluidState() {
        return this.fluidState;
    }

    public String getIsFluid() {
        return this.isFluid;
    }

    public String getIsSource() {
        return this.isSource;
    }

    @Override
    public ITargetType<PositionTarget> getAffectedType() {
        return (ITargetType)TargetTypes.POSITION.get();
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PositionTarget positionTarget) {
        FluidState fluidState = ctx.level.m_6425_(positionTarget.getBlockPos());
        ResourceLocation id = ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)fluidState.getFluidType());
        if (id == null) {
            return;
        }
        if (!fluidState.m_76178_()) {
            ctx.setCtxVar((CtxVarType)CtxVarTypes.TAG.get(), this.fluidState, SpellsUtil.stateToTag(fluidState));
        }
        ctx.setCtxVar((CtxVarType)CtxVarTypes.STRING.get(), this.fluid, id.toString());
        ctx.setCtxVar((CtxVarType)CtxVarTypes.BOOLEAN.get(), this.isFluid, !fluidState.m_76178_());
        ctx.setCtxVar((CtxVarType)CtxVarTypes.BOOLEAN.get(), this.isSource, fluidState.m_76170_());
    }
}

