/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PlayerHarvestBlockAction
extends AffectSingleTypeAction<PlayerTarget> {
    protected String blocks;
    protected Direction direction;

    public static Codec<PlayerHarvestBlockAction> makeCodec(SpellActionType<PlayerHarvestBlockAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(PlayerHarvestBlockAction.activationCodec(), PlayerHarvestBlockAction.sourceCodec(), (App)Codec.STRING.fieldOf(ParamNames.multiTarget("blocks")).forGetter(PlayerHarvestBlockAction::getBlocks), (App)SpellsUtil.namedEnumCodec(Direction::m_122402_, Direction::m_122433_).fieldOf("direction").forGetter(PlayerHarvestBlockAction::getDirection)).apply((Applicative)instance, (activation, source, blocks, direction) -> new PlayerHarvestBlockAction(type, (String)activation, (String)source, (String)blocks, (Direction)direction)));
    }

    public static PlayerHarvestBlockAction make(Object activation, Object source, Object blocks, Direction direction) {
        return new PlayerHarvestBlockAction((SpellActionType)SpellActionTypes.PLAYER_HARVEST_BLOCK.get(), activation.toString(), source.toString(), blocks.toString(), direction);
    }

    public PlayerHarvestBlockAction(SpellActionType<?> type) {
        super(type);
    }

    public PlayerHarvestBlockAction(SpellActionType<?> type, String activation, String source, String blocks, Direction direction) {
        super(type, activation, source);
        this.blocks = blocks;
        this.direction = direction;
    }

    public String getBlocks() {
        return this.blocks;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        Player player = playerTarget.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Level level = ctx.level;
            ctx.getTargetGroup(this.blocks).forEachTarget(target -> ((ITargetType)TargetTypes.POSITION.get()).ifType((Target)target, positionTarget -> {
                BlockPos pos = positionTarget.getBlockPos();
                BlockState block = level.m_8055_(pos);
                PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((Player)player2, (BlockPos)pos, (Direction)this.direction);
                if (!event.isCanceled() && !block.m_60795_() && player2.canInteractWith(pos, 2.0) && pos.m_123342_() <= level.m_151558_() && level.m_7966_((Player)player2, pos) && !player2.m_36187_(level, pos, player.f_8941_.m_9290_()) && block.m_60800_((BlockGetter)level, pos) != -1.0f) {
                    player.f_8941_.m_9280_(pos);
                }
            }));
        }
    }
}

