/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.mana;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import net.minecraft.world.entity.LivingEntity;

public class ManaCheckAction
extends AffectSingleTypeAction<PlayerTarget> {
    protected DynamicCtxVar<Double> amount;

    public static Codec<ManaCheckAction> makeCodec(SpellActionType<ManaCheckAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ManaCheckAction.activationCodec(), ManaCheckAction.singleTargetCodec(), (App)((CtxVarType)CtxVarTypes.DOUBLE.get()).refCodec().fieldOf("amount").forGetter(ManaCheckAction::getAmount)).apply((Applicative)instance, (activation, singleTarget, amount) -> new ManaCheckAction(type, (String)activation, (String)singleTarget, (DynamicCtxVar<Double>)amount)));
    }

    public static ManaCheckAction make(Object activation, Object singleTarget, DynamicCtxVar<Double> amount) {
        return new ManaCheckAction((SpellActionType)SpellActionTypes.MANA_CHECK.get(), activation.toString(), singleTarget.toString(), amount);
    }

    public ManaCheckAction(SpellActionType<?> type) {
        super(type);
    }

    public ManaCheckAction(SpellActionType<?> type, String activation, String singleTarget, DynamicCtxVar<Double> amount) {
        super(type, activation, singleTarget);
        this.amount = amount;
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }

    public DynamicCtxVar<Double> getAmount() {
        return this.amount;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PlayerTarget target) {
        if (!target.getPlayer().m_7500_()) {
            this.amount.getValue(ctx).ifPresent(amount -> ManaHolder.getManaHolder((LivingEntity)target.getPlayer()).ifPresent(manaHolder -> {
                if ((double)manaHolder.getMana() >= amount) {
                    manaHolder.burn(amount.floatValue());
                } else {
                    ctx.deactivate(this.activation);
                }
            }));
        }
    }
}

