/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.mana;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.LivingEntityTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;

public class ReplenishManaAction
extends AffectTypeAction<LivingEntityTarget> {
    protected DynamicCtxVar<Double> amount;

    public static Codec<ReplenishManaAction> makeCodec(SpellActionType<ReplenishManaAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ReplenishManaAction.activationCodec(), ReplenishManaAction.multiTargetsCodec(), (App)((CtxVarType)CtxVarTypes.DOUBLE.get()).refCodec().fieldOf(ParamNames.paramDouble("mana_amount")).forGetter(ReplenishManaAction::getAmount)).apply((Applicative)instance, (activation, multiTargets, amount) -> new ReplenishManaAction(type, (String)activation, (String)multiTargets, (DynamicCtxVar<Double>)amount)));
    }

    public static ReplenishManaAction make(Object activation, Object multiTargets, DynamicCtxVar<Double> amount) {
        return new ReplenishManaAction((SpellActionType)SpellActionTypes.REPLENISH_MANA.get(), activation.toString(), multiTargets.toString(), amount);
    }

    public ReplenishManaAction(SpellActionType<?> type) {
        super(type);
    }

    public ReplenishManaAction(SpellActionType<?> type, String activation, String multiTargets, DynamicCtxVar<Double> amount) {
        super(type, activation, multiTargets);
        this.amount = amount;
    }

    @Override
    public ITargetType<LivingEntityTarget> getAffectedType() {
        return (ITargetType)TargetTypes.LIVING_ENTITY.get();
    }

    public DynamicCtxVar<Double> getAmount() {
        return this.amount;
    }

    @Override
    public void affectTarget(SpellContext ctx, TargetGroup group, LivingEntityTarget target) {
        this.amount.getValue(ctx).ifPresent(amount -> ManaHolder.getManaHolder(target.getLivingEntity()).ifPresent(manaHolder -> manaHolder.replenish(amount.floatValue())));
    }
}

