/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.mana;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.BuiltinTargetGroups;
import de.cas_ual_ty.spells.spell.context.BuiltinVariables;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import net.minecraft.world.entity.LivingEntity;

public class SimpleManaCheckAction
extends AffectSingleTypeAction<PlayerTarget> {
    protected DynamicCtxVar<Double> amount;

    public static Codec<SimpleManaCheckAction> makeCodec(SpellActionType<SimpleManaCheckAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(SimpleManaCheckAction.activationCodec()).apply((Applicative)instance, activation -> new SimpleManaCheckAction(type, (String)activation)));
    }

    public static SimpleManaCheckAction make(Object activation) {
        return new SimpleManaCheckAction((SpellActionType)SpellActionTypes.SIMPLE_MANA_CHECK.get(), activation.toString());
    }

    public SimpleManaCheckAction(SpellActionType<?> type) {
        super(type);
    }

    public SimpleManaCheckAction(SpellActionType<?> type, String activation) {
        super(type, activation, BuiltinTargetGroups.OWNER.targetGroup);
        this.amount = ((CtxVarType)CtxVarTypes.DOUBLE.get()).reference(BuiltinVariables.MANA_COST.name);
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }

    public DynamicCtxVar<Double> getAmount() {
        return this.amount;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PlayerTarget target) {
        if (!target.getPlayer().m_7500_()) {
            this.amount.getValue(ctx).ifPresent(amount -> ManaHolder.getManaHolder((LivingEntity)target.getPlayer()).ifPresent(manaHolder -> {
                if ((double)manaHolder.getMana() >= amount) {
                    manaHolder.burn(amount.floatValue());
                } else {
                    ctx.deactivate(this.activation);
                }
            }));
        }
    }
}

