/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.target;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.DstTargetAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class EntityUUIDTargetAction
extends DstTargetAction {
    protected DynamicCtxVar<String> uuid;

    public static Codec<EntityUUIDTargetAction> makeCodec(SpellActionType<EntityUUIDTargetAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(EntityUUIDTargetAction.activationCodec(), EntityUUIDTargetAction.dstCodec(), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf(ParamNames.paramString("uuid")).forGetter(EntityUUIDTargetAction::getUuid)).apply((Applicative)instance, (activation, dst, uuid) -> new EntityUUIDTargetAction(type, (String)activation, (String)dst, (DynamicCtxVar<String>)uuid)));
    }

    public static EntityUUIDTargetAction make(Object activation, Object dst, DynamicCtxVar<String> uuid) {
        return new EntityUUIDTargetAction((SpellActionType)SpellActionTypes.ENTITY_UUID_TARGET.get(), activation.toString(), dst.toString(), uuid);
    }

    public EntityUUIDTargetAction(SpellActionType<?> type) {
        super(type);
    }

    public EntityUUIDTargetAction(SpellActionType<?> type, String activation, String dst, DynamicCtxVar<String> uuid) {
        super(type, activation, dst);
        this.uuid = uuid;
    }

    public DynamicCtxVar<String> getUuid() {
        return this.uuid;
    }

    @Override
    public void findTargets(SpellContext ctx, TargetGroup destination) {
        Level level = ctx.level;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.uuid.getValue(ctx).map(SpellsUtil::uuidFromString).ifPresent(uuid -> {
                Entity e = level2.m_8791_(uuid);
                if (e != null && e.f_19853_ == ctx.level) {
                    destination.addTargets((Target)Target.of(e));
                }
            });
        }
    }
}

