/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.target;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.projectile.HomingSpellProjectile;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PositionTarget;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.entity.Entity;

public class HomeAction
extends AffectSingleTypeAction<PositionTarget> {
    protected String target;
    protected DynamicCtxVar<Double> velocity;
    protected DynamicCtxVar<Integer> timeout;
    protected String blockHitActivation;
    protected String entityHitActivation;
    protected String timeoutActivation;
    protected String projectileDestination;

    public static Codec<HomeAction> makeCodec(SpellActionType<HomeAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(HomeAction.activationCodec(), HomeAction.sourceCodec(), (App)Codec.STRING.fieldOf(ParamNames.multiTarget()).forGetter(HomeAction::getTarget), (App)((CtxVarType)CtxVarTypes.DOUBLE.get()).refCodec().fieldOf(ParamNames.paramDouble("velocity")).forGetter(HomeAction::getVelocity), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("timeout")).forGetter(HomeAction::getTimeout), (App)Codec.STRING.fieldOf(ParamNames.asynchronousActivation("block_hit_activation")).forGetter(HomeAction::getBlockHitActivation), (App)Codec.STRING.fieldOf(ParamNames.asynchronousActivation("entity_hit_activation")).forGetter(HomeAction::getEntityHitActivation), (App)Codec.STRING.fieldOf(ParamNames.asynchronousActivation("timeout_activation")).forGetter(HomeAction::getTimeoutActivation), (App)Codec.STRING.fieldOf(ParamNames.destinationTarget("projectile")).forGetter(HomeAction::getProjectileDestination)).apply((Applicative)instance, (activation, source, target, velocity, timeout, blockHitActivation, entityHitActivation, timeoutActivation, projectileDestination) -> new HomeAction(type, (String)activation, (String)source, (String)target, (DynamicCtxVar<Double>)velocity, (DynamicCtxVar<Integer>)timeout, (String)blockHitActivation, (String)entityHitActivation, (String)timeoutActivation, (String)projectileDestination)));
    }

    public static HomeAction make(Object activation, Object source, Object target, DynamicCtxVar<Double> velocity, DynamicCtxVar<Integer> timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation, String projectileDestination) {
        return new HomeAction((SpellActionType)SpellActionTypes.HOME.get(), activation.toString(), source.toString(), target.toString(), velocity, timeout, blockHitActivation, entityHitActivation, timeoutActivation, projectileDestination);
    }

    public HomeAction(SpellActionType<?> type) {
        super(type);
    }

    public HomeAction(SpellActionType<?> type, String activation, String source, String target, DynamicCtxVar<Double> velocity, DynamicCtxVar<Integer> timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation, String projectileDestination) {
        super(type, activation, source);
        this.target = target;
        this.velocity = velocity;
        this.timeout = timeout;
        this.blockHitActivation = blockHitActivation;
        this.entityHitActivation = entityHitActivation;
        this.timeoutActivation = timeoutActivation;
        this.projectileDestination = projectileDestination;
    }

    public String getTarget() {
        return this.target;
    }

    public DynamicCtxVar<Double> getVelocity() {
        return this.velocity;
    }

    public DynamicCtxVar<Integer> getTimeout() {
        return this.timeout;
    }

    public String getBlockHitActivation() {
        return this.blockHitActivation;
    }

    public String getEntityHitActivation() {
        return this.entityHitActivation;
    }

    public String getTimeoutActivation() {
        return this.timeoutActivation;
    }

    public String getProjectileDestination() {
        return this.projectileDestination;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PositionTarget source1) {
        this.velocity.getValue(ctx).ifPresent(velocity -> this.timeout.getValue(ctx).ifPresent(timeout -> ctx.getTargetGroup(this.target).forEachTarget(target1 -> ((ITargetType)TargetTypes.ENTITY.get()).ifType((Target)target1, target -> {
            HomingSpellProjectile e = HomingSpellProjectile.home(ctx.level, source1.getPosition(), null, target.getEntity(), ctx.spell, velocity.floatValue(), timeout, this.blockHitActivation, this.entityHitActivation, this.timeoutActivation);
            if (e != null) {
                ctx.getOrCreateTargetGroup(this.projectileDestination).addTargets((Target)Target.of((Entity)e));
                ((ITargetType)TargetTypes.ENTITY.get()).ifType(source1, source -> e.m_5602_(source.getEntity()));
            }
        }))));
    }

    @Override
    public ITargetType<PositionTarget> getAffectedType() {
        return (ITargetType)TargetTypes.POSITION.get();
    }
}

