/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.target;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.BuiltinTargetGroups;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.EntityTarget;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class LookAtTargetAction
extends AffectSingleTypeAction<EntityTarget> {
    protected DynamicCtxVar<Double> range;
    protected float bbInflation;
    protected ClipContext.Block block;
    protected ClipContext.Fluid fluid;
    protected String blockHitActivation;
    protected String entityHitActivation;
    protected String missActivation;

    public static Codec<LookAtTargetAction> makeCodec(SpellActionType<LookAtTargetAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(LookAtTargetAction.activationCodec(), LookAtTargetAction.sourceCodec(), (App)((CtxVarType)CtxVarTypes.DOUBLE.get()).refCodec().fieldOf(ParamNames.paramDouble("range")).forGetter(LookAtTargetAction::getRange), (App)Codec.FLOAT.fieldOf(ParamNames.paramDoubleImm("bb_inflation")).forGetter(LookAtTargetAction::getBbInflation), (App)SpellsUtil.namedEnumCodec(SpellsUtil::blockFromString, SpellsUtil::blockToString).fieldOf("block_clip_context").forGetter(LookAtTargetAction::getBlock), (App)SpellsUtil.namedEnumCodec(SpellsUtil::fluidFromString, SpellsUtil::fluidToString).fieldOf("fluid_clip_context").forGetter(LookAtTargetAction::getFluid), (App)Codec.STRING.fieldOf(ParamNames.interactedActivation("block_hit_activation")).forGetter(LookAtTargetAction::getBlockHitActivation), (App)Codec.STRING.fieldOf(ParamNames.interactedActivation("entity_hit_activation")).forGetter(LookAtTargetAction::getEntityHitActivation), (App)Codec.STRING.fieldOf(ParamNames.interactedActivation("miss_activation")).forGetter(LookAtTargetAction::getMissActivation)).apply((Applicative)instance, (activation, source, range, bbInflation, block, fluid, blockHitActivation, entityHitActivation, missActivation) -> new LookAtTargetAction(type, (String)activation, (String)source, (DynamicCtxVar<Double>)range, bbInflation.floatValue(), (ClipContext.Block)block, (ClipContext.Fluid)fluid, (String)blockHitActivation, (String)entityHitActivation, (String)missActivation)));
    }

    public static LookAtTargetAction make(Object activation, Object source, DynamicCtxVar<Double> range, float bbInflation, ClipContext.Block block, ClipContext.Fluid fluid, String blockHitActivation, String entityHitActivation, String missActivation) {
        return new LookAtTargetAction((SpellActionType)SpellActionTypes.LOOK_AT_TARGET.get(), activation.toString(), source.toString(), range, bbInflation, block, fluid, blockHitActivation, entityHitActivation, missActivation);
    }

    public LookAtTargetAction(SpellActionType<?> type) {
        super(type);
    }

    public LookAtTargetAction(SpellActionType<?> type, String activation, String source, DynamicCtxVar<Double> range, float bbInflation, ClipContext.Block block, ClipContext.Fluid fluid, String blockHitActivation, String entityHitActivation, String missActivation) {
        super(type, activation, source);
        this.range = range;
        this.bbInflation = bbInflation;
        this.block = block;
        this.fluid = fluid;
        this.blockHitActivation = blockHitActivation;
        this.entityHitActivation = entityHitActivation;
        this.missActivation = missActivation;
    }

    @Override
    public ITargetType<EntityTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ENTITY.get();
    }

    public DynamicCtxVar<Double> getRange() {
        return this.range;
    }

    public float getBbInflation() {
        return this.bbInflation;
    }

    public ClipContext.Block getBlock() {
        return this.block;
    }

    public ClipContext.Fluid getFluid() {
        return this.fluid;
    }

    public String getBlockHitActivation() {
        return this.blockHitActivation;
    }

    public String getEntityHitActivation() {
        return this.entityHitActivation;
    }

    public String getMissActivation() {
        return this.missActivation;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, EntityTarget entityTarget) {
        this.range.getValue(ctx).ifPresent(range -> {
            HitResult hitResult = SpellsUtil.rayTrace(entityTarget.getLevel(), entityTarget.getEntity(), range, e -> true, this.bbInflation, this.block, this.fluid);
            if (hitResult.m_6662_() == HitResult.Type.MISS) {
                ctx.activate(this.missActivation);
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.HIT_POSITION.targetGroup).addTargets((Target)Target.of(entityTarget.getLevel(), hitResult.m_82450_()));
            } else if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                ctx.activate(this.blockHitActivation);
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.BLOCK_HIT.targetGroup).addTargets((Target)Target.of(entityTarget.getLevel(), blockHitResult.m_82425_()));
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.HIT_POSITION.targetGroup).addTargets((Target)Target.of(entityTarget.getLevel(), hitResult.m_82450_()));
            } else if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                ctx.activate(this.entityHitActivation);
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.ENTITY_HIT.targetGroup).addTargets((Target)Target.of(entityHitResult.m_82443_()));
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.HIT_POSITION.targetGroup).addTargets((Target)Target.of(entityTarget.getLevel(), hitResult.m_82450_()));
            }
        });
    }
}

