/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.target;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.target.CopyTargetsAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.util.ParamNames;

public class PickTargetAction
extends CopyTargetsAction {
    protected boolean remove;
    protected boolean random;

    public static Codec<PickTargetAction> makeCodec2(SpellActionType<PickTargetAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(PickTargetAction.activationCodec(), PickTargetAction.dstCodec(), PickTargetAction.srcCodec(), (App)Codec.BOOL.fieldOf(ParamNames.paramBooleanImm("remove")).forGetter(PickTargetAction::getRemove), (App)Codec.BOOL.fieldOf(ParamNames.paramBooleanImm("random")).forGetter(PickTargetAction::getRandom)).apply((Applicative)instance, (activation, dst, src, remove, random) -> new PickTargetAction(type, (String)activation, (String)dst, (String)src, (boolean)remove, (boolean)random)));
    }

    public static PickTargetAction make(Object activation, Object dst, Object src, boolean remove, boolean random) {
        return new PickTargetAction((SpellActionType)SpellActionTypes.PICK_TARGET.get(), activation.toString(), dst.toString(), src.toString(), remove, random);
    }

    public PickTargetAction(SpellActionType<?> type) {
        super(type);
    }

    public PickTargetAction(SpellActionType<?> type, String activation, String dst, String src, boolean remove, boolean random) {
        super(type, activation, dst, src);
        this.remove = remove;
        this.random = random;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public boolean getRandom() {
        return this.random;
    }

    @Override
    public void findTargets(SpellContext ctx, TargetGroup source, TargetGroup destination) {
        if (source == null || source.isEmpty()) {
            return;
        }
        int pick = this.random ? ctx.level.m_213780_().m_188503_(source.size()) : 0;
        Target t = this.remove ? source.getTargets().remove(pick) : source.getTargets().get(pick);
        destination.addTargets(t);
    }
}

