/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.target;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.SrcDstTargetAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.EntityTarget;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RangedEntityTargetsAction
extends SrcDstTargetAction {
    protected DynamicCtxVar<Double> range;

    public static Codec<RangedEntityTargetsAction> makeCodec(SpellActionType<RangedEntityTargetsAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(RangedEntityTargetsAction.activationCodec(), RangedEntityTargetsAction.dstCodec(), RangedEntityTargetsAction.srcCodec(), (App)((CtxVarType)CtxVarTypes.DOUBLE.get()).refCodec().fieldOf("range").forGetter(RangedEntityTargetsAction::getRange)).apply((Applicative)instance, (activation, dst, src, range) -> new RangedEntityTargetsAction(type, (String)activation, (String)dst, (String)src, (DynamicCtxVar<Double>)range)));
    }

    public static RangedEntityTargetsAction make(Object activation, Object dst, Object src, DynamicCtxVar<Double> range) {
        return new RangedEntityTargetsAction((SpellActionType)SpellActionTypes.RANGED_ENTITY_TARGETS.get(), activation.toString(), dst.toString(), src.toString(), range);
    }

    public RangedEntityTargetsAction(SpellActionType<?> type) {
        super(type);
    }

    public RangedEntityTargetsAction(SpellActionType<?> type, String activation, String dst, String src, DynamicCtxVar<Double> range) {
        super(type, activation, dst, src);
        this.range = range;
    }

    public DynamicCtxVar<Double> getRange() {
        return this.range;
    }

    @Override
    public void findTargets(SpellContext ctx, TargetGroup source, TargetGroup destination) {
        source.getSingleTarget(target -> ((ITargetType)TargetTypes.POSITION.get()).ifType((Target)target, position -> this.range.getValue(ctx).ifPresent(range -> {
            Level patt2545$temp = ctx.level;
            if (patt2545$temp instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt2545$temp;
                range = range * 2.0;
                Entity entity = ((ITargetType)TargetTypes.ENTITY.get()).ifType((Target)target).map(EntityTarget::getEntity).orElse(null);
                level.m_45933_(entity, AABB.m_165882_((Vec3)position.getPosition(), (double)range, (double)range, (double)range)).stream().map(Target::of).forEach(destination::addTargets);
            }
        })));
    }
}

