/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.target;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.projectile.SpellProjectile;
import de.cas_ual_ty.spells.spell.target.EntityTarget;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.entity.Entity;

public class ShootAction
extends AffectSingleTypeAction<EntityTarget> {
    protected DynamicCtxVar<Double> velocity;
    protected DynamicCtxVar<Double> inaccuracy;
    protected DynamicCtxVar<Integer> timeout;
    protected String blockHitActivation;
    protected String entityHitActivation;
    protected String timeoutActivation;
    protected String projectileDestination;

    public static Codec<ShootAction> makeCodec(SpellActionType<ShootAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ShootAction.activationCodec(), ShootAction.sourceCodec(), (App)((CtxVarType)CtxVarTypes.DOUBLE.get()).refCodec().fieldOf(ParamNames.paramDouble("velocity")).forGetter(ShootAction::getVelocity), (App)((CtxVarType)CtxVarTypes.DOUBLE.get()).refCodec().fieldOf(ParamNames.paramDouble("inaccuracy")).forGetter(ShootAction::getInaccuracy), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("timeout")).forGetter(ShootAction::getTimeout), (App)Codec.STRING.fieldOf(ParamNames.asynchronousActivation("block_hit_activation")).forGetter(ShootAction::getBlockHitActivation), (App)Codec.STRING.fieldOf(ParamNames.asynchronousActivation("entity_hit_activation")).forGetter(ShootAction::getEntityHitActivation), (App)Codec.STRING.fieldOf(ParamNames.asynchronousActivation("timeout_activation")).forGetter(ShootAction::getTimeoutActivation), (App)Codec.STRING.fieldOf(ParamNames.destinationTarget("projectile")).forGetter(ShootAction::getProjectileDestination)).apply((Applicative)instance, (activation, source, velocity, inaccuracy, timeout, blockHitActivation, entityHitActivation, timeoutActivation, projectileDestination) -> new ShootAction(type, (String)activation, (String)source, (DynamicCtxVar<Double>)velocity, (DynamicCtxVar<Double>)inaccuracy, (DynamicCtxVar<Integer>)timeout, (String)blockHitActivation, (String)entityHitActivation, (String)timeoutActivation, (String)projectileDestination)));
    }

    public static ShootAction make(Object activation, Object source, DynamicCtxVar<Double> velocity, DynamicCtxVar<Double> inaccuracy, DynamicCtxVar<Integer> timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation, String projectileDestination) {
        return new ShootAction((SpellActionType)SpellActionTypes.SHOOT.get(), activation.toString(), source.toString(), velocity, inaccuracy, timeout, blockHitActivation, entityHitActivation, timeoutActivation, projectileDestination);
    }

    public ShootAction(SpellActionType<?> type) {
        super(type);
    }

    public ShootAction(SpellActionType<?> type, String activation, String source, DynamicCtxVar<Double> velocity, DynamicCtxVar<Double> inaccuracy, DynamicCtxVar<Integer> timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation, String projectileDestination) {
        super(type, activation, source);
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.timeout = timeout;
        this.blockHitActivation = blockHitActivation;
        this.entityHitActivation = entityHitActivation;
        this.timeoutActivation = timeoutActivation;
        this.projectileDestination = projectileDestination;
    }

    public DynamicCtxVar<Double> getVelocity() {
        return this.velocity;
    }

    public DynamicCtxVar<Double> getInaccuracy() {
        return this.inaccuracy;
    }

    public DynamicCtxVar<Integer> getTimeout() {
        return this.timeout;
    }

    public String getBlockHitActivation() {
        return this.blockHitActivation;
    }

    public String getEntityHitActivation() {
        return this.entityHitActivation;
    }

    public String getTimeoutActivation() {
        return this.timeoutActivation;
    }

    public String getProjectileDestination() {
        return this.projectileDestination;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, EntityTarget entityTarget) {
        this.velocity.getValue(ctx).ifPresent(velocity -> this.inaccuracy.getValue(ctx).ifPresent(inaccuracy -> this.timeout.getValue(ctx).ifPresent(timeout -> {
            SpellProjectile e = SpellProjectile.shoot(entityTarget.getEntity(), ctx.spell, velocity.floatValue(), inaccuracy.floatValue(), timeout, this.blockHitActivation, this.entityHitActivation, this.timeoutActivation);
            if (e != null) {
                ctx.getOrCreateTargetGroup(this.projectileDestination).addTargets((Target)Target.of((Entity)e));
            }
        })));
    }

    @Override
    public ITargetType<EntityTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ENTITY.get();
    }
}

