/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.variable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.spell.action.SpellAction;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.compiler.Compiler;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class PutVarAction<T>
extends SpellAction {
    protected DynamicCtxVar<T> src;
    protected String dst;
    protected CtxVarType<T> varType;

    public static <T> Codec<PutVarAction<T>> makeCodec(SpellActionType<PutVarAction<T>> type, CtxVarType<T> varType) {
        return RecordCodecBuilder.create(instance -> instance.group(PutVarAction.activationCodec(), (App)varType.refCodec().fieldOf(ParamNames.param("source", varType)).forGetter(PutVarAction::getSrc), (App)Codec.STRING.fieldOf(ParamNames.varResult()).forGetter(PutVarAction::getDst)).apply((Applicative)instance, (activation, src, dst) -> new PutVarAction(type, (String)activation, src, (String)dst, varType)));
    }

    public static PutVarAction<Integer> makeInt(Object activation, DynamicCtxVar<Integer> src, Object dst) {
        return new PutVarAction<Integer>((SpellActionType)SpellActionTypes.PUT_INT.get(), activation.toString(), src, dst.toString(), (CtxVarType)CtxVarTypes.INT.get());
    }

    public static PutVarAction<Integer> moveInt(Object activation, Object src, Object dst) {
        return new PutVarAction<Integer>((SpellActionType)SpellActionTypes.PUT_INT.get(), activation.toString(), Compiler.compileString(src.toString(), (CtxVarType)CtxVarTypes.INT.get()), dst.toString(), (CtxVarType)CtxVarTypes.INT.get());
    }

    public static PutVarAction<Integer> makeInt(Object activation, int value, Object dst) {
        return new PutVarAction<Integer>((SpellActionType)SpellActionTypes.PUT_INT.get(), activation.toString(), ((CtxVarType)CtxVarTypes.INT.get()).immediate(value), dst.toString(), (CtxVarType)CtxVarTypes.INT.get());
    }

    public static PutVarAction<Double> makeDouble(Object activation, DynamicCtxVar<Double> src, Object dst) {
        return new PutVarAction<Double>((SpellActionType)SpellActionTypes.PUT_DOUBLE.get(), activation.toString(), src, dst.toString(), (CtxVarType)CtxVarTypes.DOUBLE.get());
    }

    public static PutVarAction<Double> moveDouble(Object activation, Object src, Object dst) {
        return new PutVarAction<Double>((SpellActionType)SpellActionTypes.PUT_DOUBLE.get(), activation.toString(), Compiler.compileString(src.toString(), (CtxVarType)CtxVarTypes.DOUBLE.get()), dst.toString(), (CtxVarType)CtxVarTypes.DOUBLE.get());
    }

    public static PutVarAction<Double> makeDouble(Object activation, double value, Object dst) {
        return new PutVarAction<Double>((SpellActionType)SpellActionTypes.PUT_DOUBLE.get(), activation.toString(), ((CtxVarType)CtxVarTypes.DOUBLE.get()).immediate(value), dst.toString(), (CtxVarType)CtxVarTypes.DOUBLE.get());
    }

    public static PutVarAction<Vec3> makeVec3(Object activation, DynamicCtxVar<Vec3> src, Object dst) {
        return new PutVarAction<Vec3>((SpellActionType)SpellActionTypes.PUT_VEC3.get(), activation.toString(), src, dst.toString(), (CtxVarType)CtxVarTypes.VEC3.get());
    }

    public static PutVarAction<Vec3> moveVec3(Object activation, Object src, Object dst) {
        return new PutVarAction<Vec3>((SpellActionType)SpellActionTypes.PUT_VEC3.get(), activation.toString(), Compiler.compileString(src.toString(), (CtxVarType)CtxVarTypes.VEC3.get()), dst.toString(), (CtxVarType)CtxVarTypes.VEC3.get());
    }

    public static PutVarAction<Vec3> makeVec3(Object activation, Vec3 value, Object dst) {
        return new PutVarAction<Vec3>((SpellActionType)SpellActionTypes.PUT_VEC3.get(), activation.toString(), ((CtxVarType)CtxVarTypes.VEC3.get()).immediate(value), dst.toString(), (CtxVarType)CtxVarTypes.VEC3.get());
    }

    public static PutVarAction<BlockPos> makeBlockPos(Object activation, DynamicCtxVar<BlockPos> src, Object dst) {
        return new PutVarAction<BlockPos>((SpellActionType)SpellActionTypes.PUT_BLOCK_POS.get(), activation.toString(), src, dst.toString(), (CtxVarType)CtxVarTypes.BLOCK_POS.get());
    }

    public static PutVarAction<BlockPos> moveBlockPos(Object activation, Object src, Object dst) {
        return new PutVarAction<BlockPos>((SpellActionType)SpellActionTypes.PUT_BLOCK_POS.get(), activation.toString(), Compiler.compileString(src.toString(), (CtxVarType)CtxVarTypes.BLOCK_POS.get()), dst.toString(), (CtxVarType)CtxVarTypes.BLOCK_POS.get());
    }

    public static PutVarAction<BlockPos> makeBlockPos(Object activation, BlockPos value, Object dst) {
        return new PutVarAction<BlockPos>((SpellActionType)SpellActionTypes.PUT_BLOCK_POS.get(), activation.toString(), ((CtxVarType)CtxVarTypes.BLOCK_POS.get()).immediate(value), dst.toString(), (CtxVarType)CtxVarTypes.BLOCK_POS.get());
    }

    public static PutVarAction<Boolean> makeBoolean(Object activation, DynamicCtxVar<Boolean> src, Object dst) {
        return new PutVarAction<Boolean>((SpellActionType)SpellActionTypes.PUT_BOOLEAN.get(), activation.toString(), src, dst.toString(), (CtxVarType)CtxVarTypes.BOOLEAN.get());
    }

    public static PutVarAction<Boolean> moveBoolean(Object activation, Object src, Object dst) {
        return new PutVarAction<Boolean>((SpellActionType)SpellActionTypes.PUT_BOOLEAN.get(), activation.toString(), Compiler.compileString(src.toString(), (CtxVarType)CtxVarTypes.BOOLEAN.get()), dst.toString(), (CtxVarType)CtxVarTypes.BOOLEAN.get());
    }

    public static PutVarAction<Boolean> makeBoolean(Object activation, boolean value, Object dst) {
        return new PutVarAction<Boolean>((SpellActionType)SpellActionTypes.PUT_BOOLEAN.get(), activation.toString(), ((CtxVarType)CtxVarTypes.BOOLEAN.get()).immediate(value), dst.toString(), (CtxVarType)CtxVarTypes.BOOLEAN.get());
    }

    public static PutVarAction<CompoundTag> makeCompoundTag(Object activation, DynamicCtxVar<CompoundTag> src, Object dst) {
        return new PutVarAction<CompoundTag>((SpellActionType)SpellActionTypes.PUT_TAG.get(), activation.toString(), src, dst.toString(), (CtxVarType)CtxVarTypes.TAG.get());
    }

    public static PutVarAction<CompoundTag> moveCompoundTag(Object activation, Object src, Object dst) {
        return new PutVarAction<CompoundTag>((SpellActionType)SpellActionTypes.PUT_TAG.get(), activation.toString(), Compiler.compileString(src.toString(), (CtxVarType)CtxVarTypes.TAG.get()), dst.toString(), (CtxVarType)CtxVarTypes.TAG.get());
    }

    public static PutVarAction<CompoundTag> makeCompoundTag(Object activation, CompoundTag value, Object dst) {
        return new PutVarAction<CompoundTag>((SpellActionType)SpellActionTypes.PUT_TAG.get(), activation.toString(), ((CtxVarType)CtxVarTypes.TAG.get()).immediate(value), dst.toString(), (CtxVarType)CtxVarTypes.TAG.get());
    }

    public static PutVarAction<String> makeString(Object activation, DynamicCtxVar<String> src, Object dst) {
        return new PutVarAction<String>((SpellActionType)SpellActionTypes.PUT_STRING.get(), activation.toString(), src, dst.toString(), (CtxVarType)CtxVarTypes.STRING.get());
    }

    public static PutVarAction<String> moveString(Object activation, Object src, Object dst) {
        return new PutVarAction<String>((SpellActionType)SpellActionTypes.PUT_STRING.get(), activation.toString(), Compiler.compileString(src.toString(), (CtxVarType)CtxVarTypes.STRING.get()), dst.toString(), (CtxVarType)CtxVarTypes.STRING.get());
    }

    public static PutVarAction<String> makeString(Object activation, String value, Object dst) {
        return new PutVarAction<String>((SpellActionType)SpellActionTypes.PUT_STRING.get(), activation.toString(), ((CtxVarType)CtxVarTypes.STRING.get()).immediate(value), dst.toString(), (CtxVarType)CtxVarTypes.STRING.get());
    }

    public PutVarAction(SpellActionType<?> type, CtxVarType<T> varType) {
        super(type);
        this.varType = varType;
    }

    public PutVarAction(SpellActionType<?> type, String activation, DynamicCtxVar<T> src, String dst, CtxVarType<T> varType) {
        super(type, activation);
        this.src = src;
        this.dst = dst;
        this.varType = varType;
    }

    public DynamicCtxVar<T> getSrc() {
        return this.src;
    }

    public String getDst() {
        return this.dst;
    }

    @Override
    protected void wasActivated(SpellContext ctx) {
        this.src.getValue(ctx).ifPresent(value -> ctx.setCtxVar(this.varType, this.dst, this.varType.copy(value)));
    }

    public static <T> SpellActionType<PutVarAction<T>> makeType(Supplier<CtxVarType<T>> varType) {
        return new SpellActionType<PutVarAction<T>>(type -> new PutVarAction((SpellActionType<?>)type, (CtxVarType)varType.get()), type -> PutVarAction.makeCodec(type, (CtxVarType)varType.get()));
    }
}

