/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.compiler;

import com.mojang.serialization.DataResult;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.spell.compiler.BinaryOperation;
import de.cas_ual_ty.spells.spell.compiler.TernaryOperation;
import de.cas_ual_ty.spells.spell.compiler.UnaryOperation;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.variable.CtxVar;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.spell.variable.ReferencedCtxVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;

public class Compiler {
    private static Map<String, Supplier<CtxVar<?>>> SUPPLIERS = new HashMap();
    private static Map<String, UnaryOperation> UNARY_FUNCTIONS = new HashMap<String, UnaryOperation>();
    private static Map<String, BinaryOperation> BINARY_FUNCTIONS = new HashMap<String, BinaryOperation>();
    private static Map<String, TernaryOperation> TERNARY_FUNCTIONS = new HashMap<String, TernaryOperation>();
    public static final Random RANDOM = new Random();
    private static int position;
    private static String s;

    public static <T> void registerSuppliers() {
        Compiler.registerSupplier("pi", CtxVarTypes.DOUBLE, () -> Math.PI);
        double sqrt2 = Math.sqrt(2.0);
        Compiler.registerSupplier("sqrt2", CtxVarTypes.DOUBLE, () -> sqrt2);
        Compiler.registerSupplier("random_int", CtxVarTypes.INT, RANDOM::nextInt);
        Compiler.registerSupplier("random_double", CtxVarTypes.DOUBLE, RANDOM::nextDouble);
        Compiler.registerSupplier("random_uuid", CtxVarTypes.STRING, () -> UUID.randomUUID().toString());
        Compiler.registerSupplier("new_tag", CtxVarTypes.TAG, () -> new CompoundTag());
    }

    public static <T> void registerSupplier(String name, Supplier<CtxVarType<T>> type, Supplier<T> value) {
        SUPPLIERS.put(name, () -> new CtxVar((CtxVarType)type.get(), value.get()));
    }

    public static void registerUnaryFunction(String name, UnaryOperation op) {
        UNARY_FUNCTIONS.put(name, op);
    }

    public static void registerBinaryFunction(String name, BinaryOperation op) {
        BINARY_FUNCTIONS.put(name, op);
    }

    public static void registerTernaryFunction(String name, TernaryOperation op) {
        TERNARY_FUNCTIONS.put(name, op);
    }

    public static <T> DataResult<DynamicCtxVar<T>> compileData(String input, CtxVarType<T> type) {
        try {
            return DataResult.success(Compiler.compile(input, type));
        }
        catch (InlineCompilationException e) {
            return DataResult.error((String)e.getMessage());
        }
    }

    public static <T> ReferencedCtxVar<T> compileString(String input, CtxVarType<T> type) {
        try {
            return Compiler.compile(input, type);
        }
        catch (InlineCompilationException e) {
            SpellsAndShields.LOGGER.error(e.getMessage());
            return new ReferencedCtxVar<T>(type, input, ctx -> Optional.empty());
        }
    }

    private static <T> ReferencedCtxVar<T> compile(String input, CtxVarType<T> type) throws InlineCompilationException {
        Part part;
        position = 0;
        s = input;
        try {
            part = Compiler.compile();
        }
        catch (InlineCompilationException e) {
            SpellsAndShields.LOGGER.error(e.getMessage());
            return new ReferencedCtxVar<T>(type, input, ctx -> Optional.empty());
        }
        if (position < s.length()) {
            throw Compiler.makeException("Expected end of string.");
        }
        return new ReferencedCtxVar<T>(type, input, ctx -> part.getValue(ctx).map(v -> v.tryConvertTo(type)));
    }

    private static InlineCompilationException makeException(String msg) {
        return new InlineCompilationException("Can not compile \"" + s + "\" at index " + position + ": " + msg);
    }

    private static void nextChar() {
        ++position;
    }

    private static char getChar() {
        if (position >= s.length()) {
            return '\u0000';
        }
        return s.charAt(position);
    }

    private static void skipSpaces() {
        while (Compiler.getChar() == ' ') {
            Compiler.nextChar();
        }
    }

    private static void nextCharSkipSpaces() {
        Compiler.nextChar();
        Compiler.skipSpaces();
    }

    private static String readName() {
        int start = position;
        if (Character.isAlphabetic(Compiler.getChar()) || Compiler.getChar() == '_') {
            Compiler.nextChar();
        }
        while (Character.isAlphabetic(Compiler.getChar()) || Character.isDigit(Compiler.getChar()) || Compiler.getChar() == '_') {
            Compiler.nextChar();
        }
        if (position == start) {
            throw Compiler.makeException("Expected identifier.");
        }
        int end = position;
        Compiler.skipSpaces();
        return s.substring(start, end);
    }

    private static Part readImmediate() {
        boolean floatingPoint = false;
        int start = position;
        while (Character.isDigit(Compiler.getChar())) {
            Compiler.nextChar();
        }
        if (Compiler.getChar() == '.') {
            Compiler.nextChar();
            floatingPoint = true;
            while (Character.isDigit(Compiler.getChar())) {
                Compiler.nextChar();
            }
        }
        if (position == start) {
            throw Compiler.makeException("Expected identifier.");
        }
        int end = position;
        Compiler.skipSpaces();
        if (floatingPoint) {
            double value = Double.parseDouble(s.substring(start, end));
            return ctx -> Optional.of(new CtxVar<Double>((CtxVarType)CtxVarTypes.DOUBLE.get(), value));
        }
        int value = Integer.parseInt(s.substring(start, end));
        return ctx -> Optional.of(new CtxVar<Integer>((CtxVarType)CtxVarTypes.INT.get(), value));
    }

    private static Part readString() {
        char c;
        if (Compiler.getChar() != '\'') {
            throw Compiler.makeException("Expected string to start with '''.");
        }
        Compiler.nextChar();
        StringBuilder s = new StringBuilder();
        while ((c = Compiler.getChar()) != '\'' && position < Compiler.s.length()) {
            s.append(c);
            Compiler.nextChar();
        }
        if (c != '\'') {
            throw Compiler.makeException("Expected string to end with '''.");
        }
        Compiler.nextChar();
        Compiler.skipSpaces();
        return ctx -> Optional.of(new CtxVar<String>((CtxVarType)CtxVarTypes.STRING.get(), s.toString()));
    }

    private static Part makeUnaryFunc(UnaryOperation op, Part operant1) {
        return ctx -> {
            Optional<CtxVar<?>> optional1 = operant1.getValue(ctx);
            AtomicReference<Object> newVar = new AtomicReference<Object>(null);
            optional1.ifPresent(op1 -> op.applyAndSet((CtxVar<?>)op1, (type, value) -> newVar.set(new CtxVar<Object>((CtxVarType<Object>)type, value))));
            if ((optional1.isEmpty() || newVar.get() == null) && ((Boolean)SpellsConfig.DEBUG_SPELLS.get()).booleanValue()) {
                SpellsAndShields.LOGGER.info("Error executing compiled unary operation \"" + op.name + "\":");
                if (optional1.isEmpty()) {
                    SpellsAndShields.LOGGER.info("Operant 1 does not exist.");
                }
                if (newVar.get() == null) {
                    SpellsAndShields.LOGGER.info("Result does not exist.");
                }
            }
            return Optional.ofNullable(newVar.get());
        };
    }

    private static Part makeBinaryFunc(BinaryOperation op, Part operant1, Part operant2) {
        return ctx -> {
            Optional<CtxVar<?>> optional1 = operant1.getValue(ctx);
            Optional<CtxVar<?>> optional2 = operant2.getValue(ctx);
            AtomicReference<Object> newVar = new AtomicReference<Object>(null);
            optional1.ifPresent(op1 -> optional2.ifPresent(op2 -> op.applyAndSet((CtxVar<?>)op1, (CtxVar<?>)op2, (type, value) -> newVar.set(new CtxVar<Object>((CtxVarType<Object>)type, value)))));
            if ((optional1.isEmpty() || optional2.isEmpty() || newVar.get() == null) && ((Boolean)SpellsConfig.DEBUG_SPELLS.get()).booleanValue()) {
                SpellsAndShields.LOGGER.info("Error executing compiled binary operation \"" + op.name + "\":");
                if (optional1.isEmpty()) {
                    SpellsAndShields.LOGGER.info("Operant 1 does not exist.");
                }
                if (optional2.isEmpty()) {
                    SpellsAndShields.LOGGER.info("Operant 2 does not exist.");
                }
                if (newVar.get() == null) {
                    SpellsAndShields.LOGGER.info("Result does not exist.");
                }
            }
            return Optional.ofNullable(newVar.get());
        };
    }

    private static Part makeTernaryFunc(TernaryOperation op, Part operant1, Part operant2, Part operant3) {
        return ctx -> {
            Optional<CtxVar<?>> optional1 = operant1.getValue(ctx);
            Optional<CtxVar<?>> optional2 = operant2.getValue(ctx);
            Optional<CtxVar<?>> optional3 = operant3.getValue(ctx);
            AtomicReference<Object> newVar = new AtomicReference<Object>(null);
            optional1.ifPresent(op1 -> optional2.ifPresent(op2 -> optional3.ifPresent(op3 -> op.applyAndSet((CtxVar<?>)op1, (CtxVar<?>)op2, (CtxVar<?>)op3, (type, value) -> newVar.set(new CtxVar<Object>((CtxVarType<Object>)type, value))))));
            if ((optional1.isEmpty() || optional2.isEmpty() || optional3.isEmpty() || newVar.get() == null) && ((Boolean)SpellsConfig.DEBUG_SPELLS.get()).booleanValue()) {
                SpellsAndShields.LOGGER.info("Error executing compiled ternary operation \"" + op.name + "\":");
                if (optional1.isEmpty()) {
                    SpellsAndShields.LOGGER.info("Operant 1 does not exist.");
                }
                if (optional2.isEmpty()) {
                    SpellsAndShields.LOGGER.info("Operant 2 does not exist.");
                }
                if (optional3.isEmpty()) {
                    SpellsAndShields.LOGGER.info("Operant 3 does not exist.");
                }
                if (newVar.get() == null) {
                    SpellsAndShields.LOGGER.info("Result does not exist.");
                }
            }
            return Optional.ofNullable(newVar.get());
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Part compileFactor() {
        Part ref;
        boolean negate = false;
        boolean not = false;
        if (Compiler.getChar() == '-') {
            Compiler.nextCharSkipSpaces();
            negate = true;
        } else if (Compiler.getChar() == '!') {
            Compiler.nextCharSkipSpaces();
            not = true;
        }
        if (Compiler.getChar() == '(') {
            Compiler.nextCharSkipSpaces();
            ref = Compiler.compileExpression();
            if (Compiler.getChar() != ')') throw Compiler.makeException("Expected ')'");
            Compiler.nextCharSkipSpaces();
        } else if (Character.isDigit(Compiler.getChar())) {
            ref = Compiler.readImmediate();
        } else if (Compiler.getChar() == '\'') {
            ref = Compiler.readString();
        } else {
            String name = Compiler.readName();
            if (Compiler.getChar() == '(') {
                TernaryOperation op;
                Compiler.nextCharSkipSpaces();
                ArrayList<Part> arguments = new ArrayList<Part>();
                if (Compiler.getChar() != ')') {
                    arguments.add(Compiler.compileExpression());
                    while (Compiler.getChar() == ',') {
                        Compiler.nextCharSkipSpaces();
                        arguments.add(Compiler.compileExpression());
                    }
                }
                if (Compiler.getChar() != ')') throw Compiler.makeException("Expected ')'");
                Compiler.nextCharSkipSpaces();
                ref = null;
                if (arguments.isEmpty()) {
                    Supplier<CtxVar<?>> supplier = SUPPLIERS.get(name);
                    ref = ctx -> Optional.ofNullable(supplier).map(Supplier::get);
                } else if (arguments.size() == 1) {
                    UnaryOperation op2 = UNARY_FUNCTIONS.get(name);
                    if (op2 != null) {
                        ref = Compiler.makeUnaryFunc(op2, (Part)arguments.get(0));
                    }
                } else if (arguments.size() == 2) {
                    BinaryOperation op3 = BINARY_FUNCTIONS.get(name);
                    if (op3 != null) {
                        ref = Compiler.makeBinaryFunc(op3, (Part)arguments.get(0), (Part)arguments.get(1));
                    }
                } else if (arguments.size() == 3 && (op = TERNARY_FUNCTIONS.get(name)) != null) {
                    ref = Compiler.makeTernaryFunc(op, (Part)arguments.get(0), (Part)arguments.get(1), (Part)arguments.get(2));
                }
                if (ref == null) {
                    throw Compiler.makeException("Unknown function \"" + name + "\" with number of arguments: " + arguments.size());
                }
            } else {
                ref = ctx -> Optional.ofNullable(ctx.getCtxVar(name));
            }
        }
        if (negate) {
            return Compiler.makeUnaryFunc(UnaryOperation.NEGATE, ref);
        }
        if (!not) return ref;
        return Compiler.makeUnaryFunc(UnaryOperation.NOT, ref);
    }

    private static Part compileProduct() {
        char sign;
        Part currentOp = Compiler.compileFactor();
        while ((sign = Compiler.getChar()) == '*' || sign == '/') {
            Compiler.nextCharSkipSpaces();
            Part op2 = Compiler.compileFactor();
            if (sign == '*') {
                currentOp = Compiler.makeBinaryFunc(BinaryOperation.MUL, currentOp, op2);
                continue;
            }
            currentOp = Compiler.makeBinaryFunc(BinaryOperation.DIV, currentOp, op2);
        }
        return currentOp;
    }

    private static Part compileSum() {
        char sign;
        Part currentOp = Compiler.compileProduct();
        while ((sign = Compiler.getChar()) == '+' || sign == '-') {
            Compiler.nextCharSkipSpaces();
            Part op2 = Compiler.compileProduct();
            if (sign == '+') {
                currentOp = Compiler.makeBinaryFunc(BinaryOperation.ADD, currentOp, op2);
                continue;
            }
            currentOp = Compiler.makeBinaryFunc(BinaryOperation.SUB, currentOp, op2);
        }
        return currentOp;
    }

    private static Part compileRelation() {
        char sign;
        Part currentOp = Compiler.compileSum();
        while ((sign = Compiler.getChar()) == '>' || sign == '<') {
            BinaryOperation op;
            Compiler.nextChar();
            if (sign == '>') {
                if (Compiler.getChar() == '=') {
                    Compiler.nextCharSkipSpaces();
                    op = BinaryOperation.GEQ;
                } else {
                    Compiler.skipSpaces();
                    op = BinaryOperation.GT;
                }
            } else if (Compiler.getChar() == '=') {
                Compiler.nextCharSkipSpaces();
                op = BinaryOperation.LEQ;
            } else {
                Compiler.skipSpaces();
                op = BinaryOperation.LT;
            }
            Part op2 = Compiler.compileSum();
            currentOp = Compiler.makeBinaryFunc(op, currentOp, op2);
        }
        return currentOp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Part compileComparison() {
        char sign;
        Part currentOp = Compiler.compileRelation();
        while ((sign = Compiler.getChar()) == '=' || sign == '!') {
            BinaryOperation op;
            Compiler.nextChar();
            if (sign == '=') {
                if (Compiler.getChar() != '=') throw Compiler.makeException("Expected '='");
                Compiler.nextCharSkipSpaces();
                op = BinaryOperation.EQ;
            } else {
                if (Compiler.getChar() != '=') throw Compiler.makeException("Expected '='");
                Compiler.nextCharSkipSpaces();
                op = BinaryOperation.NEQ;
            }
            Part op2 = Compiler.compileRelation();
            currentOp = Compiler.makeBinaryFunc(op, currentOp, op2);
        }
        return currentOp;
    }

    private static Part compileConjunction() {
        Part currentOp = Compiler.compileComparison();
        while (Compiler.getChar() == '&') {
            Compiler.nextChar();
            if (Compiler.getChar() != '&') {
                throw Compiler.makeException("Expected '&'");
            }
            Compiler.nextCharSkipSpaces();
            Part op2 = Compiler.compileComparison();
            currentOp = Compiler.makeBinaryFunc(BinaryOperation.AND, currentOp, op2);
        }
        return currentOp;
    }

    private static Part compileDisjunction() {
        Part currentOp = Compiler.compileConjunction();
        while (Compiler.getChar() == '|') {
            Compiler.nextChar();
            if (Compiler.getChar() != '|') {
                throw Compiler.makeException("Expected '|'");
            }
            Compiler.nextCharSkipSpaces();
            Part op2 = Compiler.compileConjunction();
            currentOp = Compiler.makeBinaryFunc(BinaryOperation.OR, currentOp, op2);
        }
        return currentOp;
    }

    private static Part compileConditional() {
        Part conditional = Compiler.compileDisjunction();
        if (Compiler.getChar() == '?') {
            Compiler.nextCharSkipSpaces();
            Part op1 = Compiler.compileDisjunction();
            if (Compiler.getChar() != ':') {
                throw Compiler.makeException("Expected ':'");
            }
            Compiler.nextCharSkipSpaces();
            Part op2 = Compiler.compileDisjunction();
            return Compiler.makeTernaryFunc(TernaryOperation.CONDITIONAL, conditional, op1, op2);
        }
        return conditional;
    }

    private static Part compileExpression() {
        return Compiler.compileConditional();
    }

    private static Part compile() {
        Compiler.skipSpaces();
        Part part = Compiler.compileExpression();
        Compiler.skipSpaces();
        return part;
    }

    private static class InlineCompilationException
    extends RuntimeException {
        public InlineCompilationException() {
        }

        public InlineCompilationException(String message) {
            super(message);
        }
    }

    private static interface Part {
        public Optional<CtxVar<?>> getValue(SpellContext var1);
    }

    private record Global<T>(String name, CtxVarType<T> type, Supplier<T> value) {
    }
}

