/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.context;

import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spell.action.SpellAction;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.variable.CtxVar;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class SpellContext {
    public final Level level;
    @Nullable
    public final Player owner;
    public final SpellInstance spell;
    protected List<String> activationsList;
    protected Map<String, TargetGroup> targetGroups;
    protected Map<String, CtxVar<?>> ctxVars;
    protected boolean terminated;
    protected int index;
    protected Map<String, Label> labels;
    protected int jumpLimit;

    public SpellContext(Level level, @Nullable Player owner, SpellInstance spell) {
        this.level = level;
        this.owner = owner;
        this.spell = spell;
        this.activationsList = new LinkedList<String>();
        this.targetGroups = new HashMap<String, TargetGroup>();
        this.ctxVars = new HashMap();
        this.terminated = false;
        this.index = 0;
        this.labels = new HashMap<String, Label>();
        this.jumpLimit = (Integer)SpellsConfig.ACTION_JUMP_LIMIT.get();
    }

    public Level getLevel() {
        return this.level;
    }

    public void activate(String activation) {
        if (!activation.isEmpty() && !this.activationsList.contains(activation)) {
            this.activationsList.add(activation);
        }
    }

    public void activate(List<String> activation) {
        this.activationsList.forEach(this::activate);
    }

    public void activate(String ... activations) {
        Arrays.stream(activations).forEach(this::activate);
    }

    public void deactivate(String activation) {
        if (!activation.isEmpty()) {
            this.activationsList.remove(activation);
        }
    }

    public void deactivate(List<String> activation) {
        this.activationsList.forEach(this::deactivate);
    }

    public void deactivate(String ... activations) {
        Arrays.stream(activations).forEach(this::deactivate);
    }

    public boolean isActivated(String activation) {
        return activation.isEmpty() || this.activationsList.stream().anyMatch(s -> s.equals(activation));
    }

    public boolean hasTargetGroup(String id) {
        return id.isEmpty() || this.targetGroups.containsKey(id);
    }

    public TargetGroup getTargetGroup(String id) {
        return id.isEmpty() ? TargetGroup.EMPTY : this.targetGroups.getOrDefault(id, TargetGroup.EMPTY);
    }

    public TargetGroup getOrCreateTargetGroup(String id) {
        TargetGroup tg = this.getTargetGroup(id);
        if (!id.isEmpty() && tg == TargetGroup.EMPTY) {
            tg = new TargetGroup(id);
            this.targetGroups.put(id, tg);
        }
        return tg;
    }

    public void forTargetGroup(String id, Consumer<TargetGroup> consumer) {
        TargetGroup tg = this.targetGroups.get(id);
        if (tg != null) {
            consumer.accept(tg);
        }
    }

    @Nullable
    public CtxVar<?> getCtxVar(String name) {
        return name.isEmpty() ? null : this.ctxVars.get(name);
    }

    public <T> boolean initCtxVar(CtxVar<T> variable) {
        this.ctxVars.put(variable.getName(), variable.copy());
        return true;
    }

    public <T> Optional<T> getCtxVar(CtxVarType<T> type, String name) {
        CtxVar<?> ctxVar = this.getCtxVar(name);
        if (ctxVar != null) {
            return ctxVar.tryGetAs(type);
        }
        return Optional.empty();
    }

    public <T> boolean setCtxVar(CtxVarType<T> type, String name, T value) {
        if (name.isEmpty()) {
            return false;
        }
        CtxVar<?> ctxVar = this.getCtxVar(name);
        if (ctxVar != null) {
            return ctxVar.trySet(type, value);
        }
        this.initCtxVar(new CtxVar<T>(type, name, value));
        return true;
    }

    public void addLabel(String label, SpellAction spellAction) {
        this.addLabel(this.index, label, spellAction);
    }

    public void addLabel(int index, String label, SpellAction spellAction) {
        if (label.isEmpty()) {
            return;
        }
        this.labels.put(label, new Label(index, label, spellAction));
    }

    public void jumpToLabel(String label) {
        Label l = this.labels.get(label);
        if (l != null) {
            this.setIndex(l.getIndex());
        }
    }

    public void terminate() {
        this.terminated = true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setIndex(int index) {
        if (this.jumpLimit-- > 0) {
            this.index = index;
        } else if (((Boolean)SpellsConfig.DEBUG_SPELLS.get()).booleanValue()) {
            SpellsAndShields.LOGGER.info("Hard jump limit reached! Skipping jump...");
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void run() {
        Spell spell = (Spell)this.spell.getSpell().get();
        ResourceLocation spellRl = null;
        if (((Boolean)SpellsConfig.DEBUG_SPELLS.get()).booleanValue()) {
            spellRl = Spells.getRegistry((LevelAccessor)this.level).m_7981_((Object)spell);
            SpellsAndShields.LOGGER.info("Running spell " + spellRl);
            SpellsAndShields.LOGGER.info("-".repeat(50));
            SpellsAndShields.LOGGER.info("Initial state:");
            this.debugActivations();
            this.debugTargetGroups();
            this.debugCtxVars();
            this.debugLabels();
            SpellsAndShields.LOGGER.info("-".repeat(50));
        }
        List<SpellAction> actions = spell.getSpellActions();
        this.index = 0;
        while (this.index < actions.size() && this.index >= 0) {
            SpellAction spellAction = actions.get(this.index);
            if (spellAction.doActivate(this)) {
                ResourceLocation actionRl = null;
                if (((Boolean)SpellsConfig.DEBUG_SPELLS.get()).booleanValue()) {
                    actionRl = SpellActionTypes.REGISTRY.get().getKey(spellAction.getType());
                    SpellsAndShields.LOGGER.info("Starting action " + actionRl);
                }
                spellAction.doAction(this);
                if (((Boolean)SpellsConfig.DEBUG_SPELLS.get()).booleanValue()) {
                    SpellsAndShields.LOGGER.info("Finish action " + actionRl);
                    SpellsAndShields.LOGGER.info("-".repeat(50));
                    this.debugActivations();
                    this.debugTargetGroups();
                    this.debugCtxVars();
                    this.debugLabels();
                    SpellsAndShields.LOGGER.info("-".repeat(50));
                }
                if (this.isTerminated()) break;
            }
            ++this.index;
        }
        if (((Boolean)SpellsConfig.DEBUG_SPELLS.get()).booleanValue()) {
            SpellsAndShields.LOGGER.info("Finished running spell " + spellRl);
            SpellsAndShields.LOGGER.info("-".repeat(50));
            SpellsAndShields.LOGGER.info("-".repeat(50));
        }
        this.terminate();
    }

    public void debugCtxVars() {
        SpellsAndShields.LOGGER.info("  Context variables:");
        for (CtxVar<?> v : this.ctxVars.values()) {
            SpellsAndShields.LOGGER.info("   - " + CtxVarTypes.REGISTRY.get().getKey(v.getType()) + " " + v.getName() + " / " + v.getValue().toString());
        }
    }

    public void debugTargetGroups() {
        SpellsAndShields.LOGGER.info("  Target groups:");
        for (Map.Entry<String, TargetGroup> entry : this.targetGroups.entrySet()) {
            SpellsAndShields.LOGGER.info("    " + entry.getKey() + " / " + entry.getValue().size() + ":");
            entry.getValue().forEachTarget(target -> SpellsAndShields.LOGGER.info("      - " + TargetTypes.REGISTRY.get().getKey(target.type)));
        }
    }

    public void debugActivations() {
        SpellsAndShields.LOGGER.info("  Activations:");
        for (String a : this.activationsList) {
            SpellsAndShields.LOGGER.info("   - " + a);
        }
    }

    public void debugLabels() {
        SpellsAndShields.LOGGER.info("  Labels:");
        for (Label l : this.labels.values()) {
            SpellsAndShields.LOGGER.info("   - " + l.label);
        }
    }

    private static class Label {
        private int index;
        public final String label;
        public final SpellAction spellAction;

        public Label(int index, String label, SpellAction spellAction) {
            this.index = index;
            this.label = label;
            this.spellAction = spellAction;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

