/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.context;

import de.cas_ual_ty.spells.capability.DelayedSpellHolder;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spell.context.BuiltinEvents;
import de.cas_ual_ty.spells.spell.context.BuiltinVariables;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class SpellsEvents {
    public static final Map<String, RegisteredEvent<?>> NAME_TO_ENTRY = new HashMap();

    public static void registerEvents() {
        SpellsEvents.register(BuiltinEvents.PLAYER_BREAK_SPEED.activation, PlayerEvent.BreakSpeed.class, true).addTargetLink(e -> e.getPosition().map(pos -> Target.of(e.getEntity().f_19853_, pos)).orElse(null), "block_position").addVariableLink(e -> e.getOriginalSpeed(), CtxVarTypes.DOUBLE, "original_speed").addVariableLink(e -> e.getNewSpeed(), (e, c) -> e.setNewSpeed(c.floatValue()), CtxVarTypes.DOUBLE, "new_speed");
        SpellsEvents.register(BuiltinEvents.LIVING_HURT.activation, LivingHurtEvent.class, false).addVariableLink(e -> e.getSource().m_19385_(), CtxVarTypes.STRING, "damage_type").addVariableLink(e -> e.getAmount(), (e, c) -> e.setAmount(c.floatValue()), CtxVarTypes.DOUBLE, "damage_amount");
    }

    public static <E extends EntityEvent> RegisteredEvent<E> register(String eventId, Class<E> eventClass, boolean includeClient) {
        RegisteredEvent registeredEvent = new RegisteredEvent(eventId, eventClass);
        NAME_TO_ENTRY.put(eventId, registeredEvent);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, true, eventClass, event -> {
            Consumer<SpellContext> toContext = ctx -> {
                if (event.isCancelable()) {
                    ctx.setCtxVar((CtxVarType)CtxVarTypes.BOOLEAN.get(), BuiltinVariables.EVENT_IS_CANCELED.name, event.isCanceled());
                }
                registeredEvent.getTargetLinks().forEach(link -> link.toContext((SpellContext)ctx, event));
                registeredEvent.getVariableLinks().forEach(link -> link.toContext((SpellContext)ctx, event));
            };
            Consumer<SpellContext> fromContext = ctx -> {
                if (event.isCancelable()) {
                    ctx.getCtxVar((CtxVarType)CtxVarTypes.BOOLEAN.get(), BuiltinVariables.EVENT_IS_CANCELED.name).ifPresent(arg_0 -> ((EntityEvent)event).setCanceled(arg_0));
                }
                registeredEvent.getVariableLinks().forEach(link -> link.fromContext((SpellContext)ctx, event));
            };
            DelayedSpellHolder.getHolder(event.getEntity()).ifPresent(delayedSpellHolder -> delayedSpellHolder.activateEvent(eventId, toContext, fromContext));
            Entity patt3608$temp = event.getEntity();
            if (patt3608$temp instanceof Player) {
                Player player = (Player)patt3608$temp;
                if (includeClient || !event.getEntity().f_19853_.f_46443_) {
                    SpellHolder.getSpellHolder(player).ifPresent(spellHolder -> {
                        for (int i = 0; i < spellHolder.getSlots(); ++i) {
                            SpellInstance spell = spellHolder.getSpell(i);
                            if (spell == null) continue;
                            spell.run(player, eventId, toContext, fromContext);
                        }
                    });
                }
            }
        });
        return registeredEvent;
    }

    private static class RegisteredEvent<E extends Event> {
        public final String eventId;
        public final Class<E> eventClass;
        private List<TargetLink<E, ?>> targetLinks;
        private List<VariableLink<E, ?>> variableLinks;

        public RegisteredEvent(String eventId, Class<E> eventClass) {
            this.eventId = eventId;
            this.eventClass = eventClass;
            this.targetLinks = new LinkedList();
            this.variableLinks = new LinkedList();
        }

        public <C extends Target> RegisteredEvent<E> addTargetLink(Function<E, C> getter, String targetGroup) {
            this.targetLinks.add(new TargetLink<E, C>(getter, targetGroup));
            return this;
        }

        public <C> RegisteredEvent<E> addVariableLink(Function<E, C> getter, BiConsumer<E, C> setter, Supplier<CtxVarType<C>> varType, String varName) {
            this.variableLinks.add(new VariableLink<E, C>(getter, setter, varType, varName));
            return this;
        }

        public <C> RegisteredEvent<E> addVariableLink(Function<E, C> getter, Supplier<CtxVarType<C>> varType, String varName) {
            return this.addVariableLink(getter, (e, c) -> {}, varType, varName);
        }

        protected List<TargetLink<E, ?>> getTargetLinks() {
            return this.targetLinks;
        }

        protected List<VariableLink<E, ?>> getVariableLinks() {
            return this.variableLinks;
        }
    }

    private record VariableLink<E extends Event, C>(Function<E, C> getter, BiConsumer<E, C> setter, Supplier<CtxVarType<C>> varType, String varName) {
        public void toContext(SpellContext ctx, E e) {
            C c = this.getter.apply(e);
            if (c != null) {
                ctx.setCtxVar(this.varType.get(), this.varName, c);
            }
        }

        public void fromContext(SpellContext ctx, E e) {
            ctx.getCtxVar(this.varType.get(), this.varName).ifPresent(c -> this.setter.accept(e, c));
        }
    }

    private record TargetLink<E extends Event, C extends Target>(Function<E, C> getter, String targetGroup) {
        public void toContext(SpellContext ctx, E e) {
            Target c = (Target)this.getter.apply(e);
            if (c != null) {
                ctx.getOrCreateTargetGroup(this.targetGroup).addTargets(c);
            }
        }
    }
}

