/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.context;

import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class TargetGroup {
    public final String id;
    private List<Target> targetsList;
    public static TargetGroup EMPTY = new TargetGroup(""){

        @Override
        public List<Target> getTargets() {
            return List.of();
        }

        @Override
        public void forEachTarget(Consumer<Target> consumer) {
        }

        @Override
        public <T extends Target> void forEachType(ITargetType<T> type, Consumer<T> consumer) {
        }

        @Override
        public void addTargets(Target target) {
        }

        @Override
        public void addTargets(List<Target> targets) {
        }

        @Override
        public void addTargets(Target ... targets) {
        }
    };

    public TargetGroup(String id) {
        this.id = id;
        this.targetsList = new ArrayList<Target>();
    }

    public List<Target> getTargets() {
        return this.targetsList;
    }

    public void forEachTarget(Consumer<Target> consumer) {
        this.targetsList.forEach(consumer);
    }

    public <T extends Target> void forEachType(ITargetType<T> type, Consumer<T> consumer) {
        this.forEachTarget(target -> {
            if (type.isType((Target)target)) {
                consumer.accept(type.asType((Target)target));
            }
        });
    }

    public void addTargets(Target target) {
        this.targetsList.add(target);
    }

    public void addTargets(List<Target> targets) {
        this.targetsList.addAll(targets);
    }

    public void addTargets(Target ... targets) {
        this.addTargets(Arrays.asList(targets));
    }

    public boolean isEmpty() {
        return this.targetsList.isEmpty();
    }

    public boolean isSingleTarget() {
        return this.targetsList.size() == 1;
    }

    public int size() {
        return this.targetsList.size();
    }

    public void clear() {
        this.targetsList.clear();
    }

    public void getSingleTarget(Consumer<Target> consumer) {
        if (this.isSingleTarget()) {
            consumer.accept(this.targetsList.get(0));
        }
    }
}

