/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.projectile;

import de.cas_ual_ty.spells.registers.BuiltinRegistries;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spell.projectile.SpellProjectile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HomingSpellProjectile
extends SpellProjectile {
    protected UUID targetUUID;
    protected Entity cachedTarget;

    public HomingSpellProjectile(EntityType<? extends HomingSpellProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public HomingSpellProjectile(EntityType<? extends AbstractHurtingProjectile> pEntityType, Level pLevel, SpellInstance spell, int timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation) {
        super(pEntityType, pLevel, spell, timeout, blockHitActivation, entityHitActivation, timeoutActivation);
    }

    public void setOwnerAndTarget(Entity owner, Entity target) {
        this.m_5602_(owner);
        this.setTarget(target);
    }

    public void home(float velocity) {
        Vec3 direction = this.cachedTarget.m_146892_().m_82546_(this.m_20182_()).m_82541_();
        this.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, 0.0f);
    }

    @Override
    public void m_8119_() {
        if (this.getTarget() != null && !this.getTarget().m_213877_()) {
            Vec3 movement = this.m_20184_();
            this.home((float)movement.m_82553_());
        }
        super.m_8119_();
    }

    public void setTarget(Entity target) {
        this.targetUUID = target.m_20148_();
        this.cachedTarget = target;
    }

    public Entity getTarget() {
        Level level;
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cachedTarget = serverLevel.m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.targetUUID != null) {
            pCompound.m_128362_("Target", this.targetUUID);
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("Target")) {
            this.targetUUID = pCompound.m_128342_("Target");
        }
    }

    public static HomingSpellProjectile home(Level level0, Vec3 position, @Nullable Entity source, Entity target, SpellInstance spell, float velocity, int timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation) {
        if (level0 instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)level0;
            Vec3 direction = target.m_146892_().m_82546_(position).m_82541_();
            HomingSpellProjectile projectile = new HomingSpellProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)BuiltinRegistries.HOMING_SPELL_PROJECTILE.get()), (Level)level, spell, timeout, blockHitActivation, entityHitActivation, timeoutActivation);
            projectile.setOwnerAndTarget(source, target);
            projectile.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, 0.0f, 0.0f);
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, 0.0f);
            level.m_7967_((Entity)projectile);
            return projectile;
        }
        return null;
    }

    public static HomingSpellProjectile home(Entity source, Entity target, SpellInstance spell, float velocity, int timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation) {
        return HomingSpellProjectile.home(source.f_19853_, source.m_146892_(), source, target, spell, velocity, timeout, blockHitActivation, entityHitActivation, timeoutActivation);
    }
}

