/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.projectile;

import de.cas_ual_ty.spells.registers.BuiltinRegistries;
import de.cas_ual_ty.spells.registers.SpellTrees;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spell.context.BuiltinTargetGroups;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class SpellProjectile
extends AbstractHurtingProjectile {
    protected SpellInstance spell;
    protected int timeout;
    protected String blockHitActivation;
    protected String entityHitActivation;
    protected String timeoutActivation;

    public SpellProjectile(EntityType<? extends SpellProjectile> entityType, Level level) {
        super(entityType, level);
        this.spell = null;
        this.timeout = -1;
        this.blockHitActivation = null;
        this.entityHitActivation = null;
        this.timeoutActivation = null;
    }

    public SpellProjectile(EntityType<? extends AbstractHurtingProjectile> pEntityType, Level pLevel, SpellInstance spell, int timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation) {
        super(pEntityType, pLevel);
        this.spell = spell;
        this.timeout = timeout;
        this.blockHitActivation = blockHitActivation;
        this.entityHitActivation = entityHitActivation;
        this.timeoutActivation = timeoutActivation;
    }

    protected float m_6884_() {
        return 1.0f;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123759_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.spell != null && !this.f_19853_.m_5776_() && this.f_19797_ >= this.timeout) {
            this.spell.forceRun(this.f_19853_, this.getPlayerOwner(), this.timeoutActivation, ctx -> ctx.getOrCreateTargetGroup(BuiltinTargetGroups.PROJECTILE.targetGroup).addTargets((Target)Target.of((Entity)this)));
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        if (this.spell != null && !this.f_19853_.m_5776_() && !(entityHitResult.m_82443_() instanceof SpellProjectile)) {
            this.spell.forceRun(this.f_19853_, this.getPlayerOwner(), this.entityHitActivation, ctx -> {
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.PROJECTILE.targetGroup).addTargets((Target)Target.of((Entity)this));
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.ENTITY_HIT.targetGroup).addTargets((Target)Target.of(entityHitResult.m_82443_()));
                Vec3 clip = entityHitResult.m_82443_().m_20191_().m_82371_(this.m_20182_().m_82546_(this.m_20184_()), this.m_20182_().m_82549_(this.m_20184_())).orElse(entityHitResult.m_82443_().m_146892_());
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.HIT_POSITION.targetGroup).addTargets((Target)Target.of(this.f_19853_, clip));
            });
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        if (this.spell != null && !this.f_19853_.m_5776_()) {
            this.spell.forceRun(this.f_19853_, this.getPlayerOwner(), this.blockHitActivation, ctx -> {
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.PROJECTILE.targetGroup).addTargets((Target)Target.of((Entity)this));
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.BLOCK_HIT.targetGroup).addTargets((Target)Target.of(this.f_19853_, blockHitResult.m_82425_()));
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.HIT_POSITION.targetGroup).addTargets((Target)Target.of(this.f_19853_, blockHitResult.m_82450_()));
            });
            this.m_146870_();
        }
    }

    public boolean m_5931_() {
        return false;
    }

    @Nullable
    public SpellInstance getSpell() {
        return this.spell;
    }

    public void setSpell(SpellInstance spell) {
        this.spell = spell;
    }

    @Nullable
    public Player getPlayerOwner() {
        ServerPlayer player;
        Entity entity = this.m_37282_();
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_9232_()) {
            return player;
        }
        return null;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.spell != null) {
            if (this.spell.getNodeId() != null) {
                CompoundTag tag = new CompoundTag();
                this.spell.getNodeId().toNbt(tag);
                nbt.m_128365_("Spell", (Tag)tag);
            } else {
                Registry<Spell> spellRegistry = Spells.getRegistry((LevelAccessor)this.f_19853_);
                nbt.m_128359_("spellId", ((ResourceLocation)this.spell.getSpell().m_203439_().map(ResourceKey::m_135782_, arg_0 -> spellRegistry.m_7981_(arg_0))).toString());
            }
        } else {
            this.m_146870_();
        }
        nbt.m_128405_("Timeout", this.timeout);
        nbt.m_128359_("BlockHitActivation", this.blockHitActivation);
        nbt.m_128359_("EntityHitActivation", this.entityHitActivation);
        nbt.m_128359_("TimeoutActivation", this.timeoutActivation);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Spell", 10)) {
            Registry<Spell> spellRegistry;
            Holder holder;
            SpellNodeId spellNodeId = SpellNodeId.fromNbt(nbt.m_128469_("Spell"));
            if (spellNodeId != null) {
                this.spell = spellNodeId.getSpellInstance(SpellTrees.getRegistry((LevelAccessor)this.f_19853_));
            } else if (nbt.m_128425_("spellId", 8) && (holder = (Holder)(spellRegistry = Spells.getRegistry((LevelAccessor)this.f_19853_)).m_203636_(ResourceKey.m_135785_(Spells.REGISTRY_KEY, (ResourceLocation)new ResourceLocation(nbt.m_128461_("spellId")))).orElse(null)) != null) {
                this.spell = new SpellInstance((Holder<Spell>)holder);
            }
        }
        if (this.spell == null) {
            this.m_146870_();
            return;
        }
        this.timeout = nbt.m_128451_("Timeout");
        this.blockHitActivation = nbt.m_128461_("BlockHitActivation");
        this.entityHitActivation = nbt.m_128461_("EntityHitActivation");
        this.timeoutActivation = nbt.m_128461_("TimeoutActivation");
    }

    public static SpellProjectile shoot(Vec3 position, Vec3 direction, @Nullable Entity source, SpellInstance spell, float velocity, float inaccuracy, int timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation) {
        Level level = source.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            SpellProjectile projectile = new SpellProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)BuiltinRegistries.SPELL_PROJECTILE.get()), (Level)level2, spell, timeout, blockHitActivation, entityHitActivation, timeoutActivation);
            projectile.m_5602_(source);
            projectile.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, 0.0f, 0.0f);
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, inaccuracy);
            level2.m_7967_((Entity)projectile);
            return projectile;
        }
        return null;
    }

    public static SpellProjectile shoot(Entity source, SpellInstance spell, float velocity, float inaccuracy, int timeout, String blockHitActivation, String entityHitActivation, String timeoutActivation) {
        return SpellProjectile.shoot(source.m_146892_(), source.m_20154_().m_82541_(), source, spell, velocity, inaccuracy, timeout, blockHitActivation, entityHitActivation, timeoutActivation);
    }
}

