/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.target;

import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.target.EntityTarget;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.target.LivingEntityTarget;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.target.StaticTarget;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class Target {
    public final ITargetType<?> type;

    public Target(ITargetType<?> type) {
        this.type = type;
    }

    public abstract Level getLevel();

    public static EntityTarget of(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return new PlayerTarget((ITargetType)TargetTypes.PLAYER.get(), player);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return new LivingEntityTarget((ITargetType)TargetTypes.LIVING_ENTITY.get(), livingEntity);
        }
        return new EntityTarget((ITargetType)TargetTypes.ENTITY.get(), entity);
    }

    public static StaticTarget of(Level level, BlockPos blockPos) {
        return new StaticTarget((ITargetType)TargetTypes.STATIC.get(), level, blockPos);
    }

    public static StaticTarget of(Level level, Vec3 position) {
        return new StaticTarget((ITargetType)TargetTypes.STATIC.get(), level, position);
    }

    public static ItemTarget of(Level level, ItemStack item, Consumer<ItemStack> setter, boolean isCreative) {
        return new ItemTarget((ITargetType)TargetTypes.ITEM.get(), level, item, setter, isCreative);
    }
}

