/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.variable;

import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import java.util.Optional;
import javax.annotation.Nullable;

public class CtxVar<T> {
    protected CtxVarType<T> type;
    protected String name;
    protected T value;
    protected Optional<T> optional;

    public CtxVar(CtxVarType<T> type) {
        this.type = type;
    }

    public CtxVar(CtxVarType<T> type, String name, T value) {
        this(type);
        this.name = name;
        this.setValue(value);
    }

    public CtxVar(CtxVarType<T> type, T value) {
        this(type, null, value);
    }

    public CtxVarType<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.type.copy(this.value);
    }

    public Optional<T> getOptional() {
        return this.optional;
    }

    public void setValue(T value) {
        this.value = value;
        this.optional = Optional.of(value);
    }

    public <U> boolean trySet(CtxVarType<U> type, U value) {
        if (type.canConvertTo(this.type)) {
            this.setValue(type.convertTo(this.type, value));
            return true;
        }
        return false;
    }

    public <U> Optional<U> tryGetAs(CtxVarType<U> type) {
        return Optional.ofNullable(this.type.convertTo(type, this.value));
    }

    @Nullable
    public <U> U tryConvertTo(CtxVarType<U> type) {
        return this.type.convertTo(type, this.value);
    }

    public CtxVar<T> copy() {
        return new CtxVar<T>(this.type, this.name, this.value);
    }
}

