/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.variable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.spell.variable.CtxVar;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.spell.variable.ImmediateCtxVar;
import de.cas_ual_ty.spells.spell.variable.ReferencedCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public class CtxVarType<T> {
    private Function<T, T> copyFunc;
    private Codec<T> immCodec;
    private Codec<CtxVar<T>> codec;
    private Map<CtxVarType<?>, Function<T, ?>> converters;

    public CtxVarType(Function<T, T> copyFunc, Codec<T> immCodec) {
        this.copyFunc = copyFunc;
        this.immCodec = immCodec;
        this.converters = new HashMap();
        this.codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf(ParamNames.var("name")).forGetter(CtxVar::getName), (App)this.getImmCodec().fieldOf("value").forGetter(CtxVar::getValue)).apply((Applicative)instance, (name, value) -> new CtxVar<Object>(this, (String)name, value)));
    }

    public <U> CtxVarType<T> addConverter(CtxVarType<U> typeTo, Function<T, U> converter) {
        this.converters.put(typeTo, converter);
        return this;
    }

    public T copy(T t) {
        return this.copyFunc.apply(t);
    }

    public Codec<CtxVar<T>> getCodec() {
        return this.codec;
    }

    public Codec<T> getImmCodec() {
        return this.immCodec;
    }

    @Nullable
    public <U> U convertTo(CtxVarType<U> typeTo, T value) {
        if (typeTo == this) {
            return (U)value;
        }
        Function<T, ?> converter = this.converters.get(typeTo);
        if (converter != null) {
            return (U)converter.apply(value);
        }
        return null;
    }

    public <U> boolean canConvertTo(CtxVarType<U> typeTo) {
        return typeTo == this || this.converters.containsKey(typeTo);
    }

    public Codec<DynamicCtxVar<T>> refCodec() {
        return DynamicCtxVar.makeCodec(this);
    }

    public DynamicCtxVar<T> immediate(T value) {
        return new ImmediateCtxVar<T>(this, value);
    }

    public DynamicCtxVar<T> reference(Object name) {
        return new ReferencedCtxVar(this, name.toString(), ctx -> ctx.getCtxVar(this, name.toString()));
    }

    public String toString() {
        return CtxVarTypes.REGISTRY.get().getKey((Object)this).toString();
    }
}

