/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.variable;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import de.cas_ual_ty.spells.spell.compiler.Compiler;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.ImmediateCtxVar;
import de.cas_ual_ty.spells.spell.variable.ReferencedCtxVar;
import java.util.Optional;

public abstract class DynamicCtxVar<I> {
    public static final String VAR_PREFIX = "<<";
    public static final String VAR_SUFFIX = ">>";
    private CtxVarType<I> type;

    public static <I> Codec<DynamicCtxVar<I>> makeCodec(final CtxVarType<I> type) {
        return new PrimitiveCodec<DynamicCtxVar<I>>(){

            public <T> DataResult<DynamicCtxVar<I>> read(DynamicOps<T> ops, T input) {
                String name;
                DataResult nameResult = ops.getStringValue(input);
                if (nameResult.result().isPresent() && (name = (String)nameResult.result().get()).startsWith(DynamicCtxVar.VAR_PREFIX) && name.endsWith(DynamicCtxVar.VAR_SUFFIX)) {
                    name = name.substring(0, name.length() - DynamicCtxVar.VAR_SUFFIX.length()).substring(DynamicCtxVar.VAR_PREFIX.length());
                    return Compiler.compileData(name, type);
                }
                DataResult immResult = type.getImmCodec().parse(ops, input);
                return immResult.map(imm -> new ImmediateCtxVar<Object>(type, imm));
            }

            public <T> T write(DynamicOps<T> ops, DynamicCtxVar<I> value) {
                if (value instanceof ReferencedCtxVar) {
                    ReferencedCtxVar dyn = (ReferencedCtxVar)value;
                    return (T)ops.createString(dyn.compiledString());
                }
                if (value instanceof ImmediateCtxVar) {
                    ImmediateCtxVar imm = (ImmediateCtxVar)value;
                    Optional r = type.getImmCodec().encodeStart(ops, imm.getImm()).result();
                    if (r.isPresent()) {
                        return r.get();
                    }
                }
                throw new IllegalStateException();
            }
        };
    }

    public DynamicCtxVar(CtxVarType<I> type) {
        this.type = type;
    }

    public CtxVarType<I> getType() {
        return this.type;
    }

    public abstract Optional<I> getValue(SpellContext var1);

    public <J> Optional<J> tryGetAs(SpellContext ctx, CtxVarType<J> type) {
        return this.getValue(ctx).map(i -> this.type.convertTo(type, i));
    }
}

