/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.variable;

import de.cas_ual_ty.spells.spell.compiler.Compiler;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import java.util.Optional;

public class ReferencedCtxVar<T>
extends DynamicCtxVar<T> {
    private String str;
    private Expression<T> expression;

    public ReferencedCtxVar(CtxVarType<T> type, String str, Expression<T> expression) {
        super(type);
        this.str = str;
        this.expression = expression;
    }

    @Override
    public Optional<T> getValue(SpellContext ctx) {
        return this.expression.getValue(ctx);
    }

    public String getStr() {
        return this.str;
    }

    public String compiledString() {
        return "<<" + this.str + ">>";
    }

    public static <T> ReferencedCtxVar<T> makeExpression(CtxVarType<T> type, String str) {
        return Compiler.compileString(str, type);
    }

    public static interface Expression<T> {
        public Optional<T> getValue(SpellContext var1);
    }
}

