/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelltree;

import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class SpellNode {
    protected SpellNodeId nodeId;
    protected final SpellInstance spell;
    protected int levelCost;
    protected List<Requirement> hiddenRequirements;
    protected List<Requirement> learnRequirements;
    protected int frame;
    protected SpellNode parent;
    protected List<SpellNode> children;

    public SpellNode(SpellNodeId nodeId, SpellInstance spell, int levelCost, List<Requirement> hiddenRequirements, List<Requirement> learnRequirements, List<SpellNode> children, int frame) {
        this.nodeId = nodeId;
        this.spell = spell;
        this.levelCost = Math.max(0, levelCost);
        this.hiddenRequirements = hiddenRequirements;
        this.learnRequirements = learnRequirements;
        this.children = children;
        this.frame = frame;
    }

    public SpellNode(SpellNodeId nodeId, SpellInstance spell, int levelCost, List<Requirement> hiddenRequirements, List<Requirement> learnRequirements, int frame) {
        this(nodeId, spell, levelCost, hiddenRequirements, learnRequirements, new LinkedList<SpellNode>(), frame);
    }

    public SpellNode(int nodeId, SpellInstance spell, int levelCost, List<Requirement> hiddenRequirements, List<Requirement> learnRequirements, int frame) {
        this(new SpellNodeId(null, nodeId), spell, levelCost, hiddenRequirements, learnRequirements, new LinkedList<SpellNode>(), frame);
    }

    public SpellNode(int nodeId, SpellInstance spell) {
        this(new SpellNodeId(null, nodeId), spell, 0, new LinkedList<Requirement>(), new LinkedList<Requirement>(), new LinkedList<SpellNode>(), 0);
    }

    public SpellNode(SpellInstance spell, int levelCost, List<Requirement> hiddenRequirements, List<Requirement> learnRequirements, int frame) {
        this(null, spell, levelCost, hiddenRequirements, learnRequirements, frame);
    }

    public SpellNode(SpellInstance spell) {
        this(null, spell, 0, new LinkedList<Requirement>(), new LinkedList<Requirement>(), 0);
    }

    public SpellInstance getSpellInstance() {
        return this.spell;
    }

    public int getLevelCost() {
        return this.levelCost;
    }

    public void setLevelCost(int levelCost) {
        this.levelCost = levelCost;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public List<Requirement> getHiddenRequirements() {
        return this.hiddenRequirements;
    }

    public List<Requirement> getLearnRequirements() {
        return this.learnRequirements;
    }

    public void addHiddenRequirement(Requirement requirement) {
        this.hiddenRequirements.add(requirement);
    }

    public void addLearnRequirement(Requirement requirement) {
        this.learnRequirements.add(requirement);
    }

    public void setHiddenRequirements(List<Requirement> requirements) {
        this.hiddenRequirements = requirements;
    }

    public void setLearnRequirements(List<Requirement> requirements) {
        this.learnRequirements = requirements;
    }

    public Spell getSpellDirect() {
        return (Spell)this.spell.getSpell().get();
    }

    public boolean passesHidden(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return this.hiddenRequirements.stream().allMatch(requirement -> requirement.passes(spellProgressionHolder, access));
    }

    public boolean passesLearn(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return this.hiddenRequirements.stream().allMatch(requirement -> requirement.passes(spellProgressionHolder, access)) && this.learnRequirements.stream().allMatch(requirement -> requirement.passes(spellProgressionHolder, access));
    }

    public void onSpellLearned(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        this.hiddenRequirements.forEach(requirement -> requirement.onSpellLearned(spellProgressionHolder, access));
        this.learnRequirements.forEach(requirement -> requirement.onSpellLearned(spellProgressionHolder, access));
    }

    public boolean canSee(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return spellProgressionHolder.getPlayer().m_7500_() || this.passesHidden(spellProgressionHolder, access);
    }

    public boolean canLearn(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return spellProgressionHolder.getPlayer().m_7500_() || spellProgressionHolder.getPlayer().f_36078_ >= this.levelCost && this.passesLearn(spellProgressionHolder, access);
    }

    public List<Component> getTooltip(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        LinkedList<Component> tooltips = new LinkedList<Component>();
        tooltips.add(this.getSpellDirect().getTitle());
        this.hiddenRequirements.forEach(requirement -> tooltips.add((Component)requirement.makeDescription(spellProgressionHolder, access)));
        this.learnRequirements.forEach(requirement -> tooltips.add((Component)requirement.makeDescription(spellProgressionHolder, access)));
        return tooltips;
    }

    public void setParent(@Nullable SpellNode parent) {
        this.parent = parent;
    }

    public void addChild(SpellNode child) {
        this.children.add(child);
    }

    public SpellNode copy() {
        return new SpellNode(this.nodeId, this.spell.copy(), this.levelCost, this.hiddenRequirements, this.learnRequirements, this.frame);
    }

    @Nullable
    public SpellNode getParent() {
        return this.parent;
    }

    public List<SpellNode> getChildren() {
        return this.children;
    }

    public SpellNodeId getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(ResourceLocation sourceTree, int id) {
        this.nodeId = this.nodeId != null ? new SpellNodeId(sourceTree, this.nodeId.nodeId()) : new SpellNodeId(sourceTree, id);
        this.spell.initId(this.nodeId);
    }
}

