/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelltree;

import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record SpellNodeId(ResourceLocation treeId, int nodeId) {
    public SpellTree getSpellTree(Registry<SpellTree> registry) {
        return (SpellTree)registry.m_7745_(this.treeId);
    }

    public SpellNode getSpellNode(Registry<SpellTree> registry) {
        SpellTree tree = this.getSpellTree(registry);
        return tree.findNode(this.nodeId);
    }

    public SpellInstance getSpellInstance(Registry<SpellTree> registry) {
        SpellNode node = this.getSpellNode(registry);
        return node == null ? null : node.getSpellInstance();
    }

    public void toNbt(CompoundTag nbt) {
        nbt.m_128359_("treeId", this.treeId().toString());
        nbt.m_128405_("nodeId", this.nodeId());
    }

    @Nullable
    public static SpellNodeId fromNbt(CompoundTag nbt) {
        if (!nbt.m_128441_("treeId") || !nbt.m_128441_("nodeId")) {
            return null;
        }
        ResourceLocation treeId = new ResourceLocation(nbt.m_128461_("treeId"));
        int nodeId = nbt.m_128451_("nodeId");
        return new SpellNodeId(treeId, nodeId);
    }

    public void toBuf(FriendlyByteBuf buf) {
        buf.m_130085_(this.treeId());
        buf.writeShort(this.nodeId());
    }

    public static SpellNodeId fromBuf(FriendlyByteBuf buf) {
        ResourceLocation treeId = buf.m_130281_();
        short nodeId = buf.readShort();
        return new SpellNodeId(treeId, nodeId);
    }

    @Override
    public String toString() {
        return this.treeId + "/" + this.nodeId;
    }
}

