/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelltree;

import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spell.icon.SpellIcon;
import de.cas_ual_ty.spells.spell.variable.CtxVar;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class SpellTree {
    private SpellNode root;
    private Component title;
    private SpellIcon icon;
    private ResourceLocation id;

    public SpellTree(SpellNode root, Component title, SpellIcon icon) {
        this.root = root;
        this.title = title;
        this.icon = icon;
        this.id = null;
    }

    public ResourceLocation getId(Registry<SpellTree> registry) {
        return registry.m_7981_((Object)this);
    }

    public SpellNode getRoot() {
        return this.root;
    }

    public Component getTitle() {
        return this.title;
    }

    public List<Component> getTooltip(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        LinkedList<Component> tooltips = new LinkedList<Component>();
        tooltips.add(this.getTitle());
        this.getRequirements().forEach((? super T requirement) -> tooltips.add((Component)requirement.makeDescription(spellProgressionHolder, access).m_130940_(ChatFormatting.GRAY)));
        return tooltips;
    }

    public SpellIcon getIcon() {
        return this.icon;
    }

    public List<Requirement> getRequirements() {
        return this.root.getHiddenRequirements();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public SpellTree setId(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public int getDepth(Spell spell) {
        if (this.root == null) {
            return 0;
        }
        return this.find(1, this.root, spell);
    }

    private int find(int depth, SpellNode spellNode, Spell spell) {
        if (spellNode.getSpellDirect() == spell) {
            return depth;
        }
        ++depth;
        for (SpellNode child : spellNode.getChildren()) {
            int found = this.find(depth, child, spell);
            if (found == 0) continue;
            return found;
        }
        return 0;
    }

    public void assignNodeIds(ResourceLocation spellTreeId) {
        this.setId(spellTreeId);
        AtomicInteger i = new AtomicInteger(0);
        this.forEach(spellNode -> {
            if (spellNode.getNodeId() != null) {
                i.set(Math.max(spellNode.getNodeId().nodeId(), i.get()));
            }
        });
        this.forEach(spellNode -> spellNode.setNodeId(spellTreeId, i.getAndIncrement()));
    }

    @Nullable
    public SpellNode findNode(int id) {
        Stack<SpellNode> stack = new Stack<SpellNode>();
        stack.push(this.root);
        while (!stack.isEmpty()) {
            SpellNode node = (SpellNode)stack.pop();
            if (node.getNodeId().nodeId() == id) {
                return node;
            }
            node.getChildren().forEach(stack::push);
        }
        return null;
    }

    public void forEach(Consumer<SpellNode> consumer) {
        if (this.root != null) {
            this.innerForEach(this.root, consumer);
        }
    }

    private void innerForEach(SpellNode spellNode, Consumer<SpellNode> consumer) {
        consumer.accept(spellNode);
        for (SpellNode child : spellNode.getChildren()) {
            this.innerForEach(child, consumer);
        }
    }

    public SpellTree copy() {
        return new SpellTree(this.innerDeepCopy(this.root), this.title, this.icon).setId(this.id);
    }

    private SpellNode innerDeepCopy(SpellNode original) {
        SpellNode copy = original.copy();
        for (SpellNode child : original.getChildren()) {
            SpellTree.connect(copy, this.innerDeepCopy(child));
        }
        return copy;
    }

    public static void connect(SpellNode parent, SpellNode child) {
        parent.addChild(child);
        child.setParent(parent);
    }

    public static Builder builder(Component title) {
        return new Builder(title);
    }

    public static class Builder {
        private Component title;
        private SpellNode root;
        private SpellIcon icon;
        private Stack<SpellNode> stack;

        private Builder(Component title) {
            this.title = title;
            this.root = null;
            this.icon = null;
            this.stack = new Stack();
        }

        public Builder icon(SpellIcon spell) {
            this.icon = spell;
            return this;
        }

        public Builder add(int nodeId, Holder<Spell> spell) {
            return this.add(new SpellNode(nodeId, new SpellInstance(spell)));
        }

        public Builder add(Holder<Spell> spell) {
            return this.add(new SpellNode(new SpellInstance(spell)));
        }

        public Builder add(SpellNode spellNode) {
            if (!this.stack.isEmpty()) {
                SpellNode parent = this.stack.peek();
                if (spellNode.getNodeId() == null) {
                    if (parent.getChildren().size() > 15) {
                        throw new IllegalStateException();
                    }
                    int newId = parent.getNodeId().nodeId() * 16 + parent.getChildren().size();
                    if (newId < 0 || newId < parent.getNodeId().nodeId()) {
                        throw new IllegalStateException();
                    }
                    spellNode.setNodeId(null, newId);
                }
                SpellTree.connect(parent, spellNode);
            } else {
                if (spellNode.getNodeId() == null) {
                    spellNode.setNodeId(null, 1);
                }
                this.root = spellNode;
            }
            this.stack.push(spellNode);
            return this;
        }

        public Builder leaf() {
            this.stack.pop();
            return this;
        }

        public Builder levelCost(int levelCost) {
            this.stack.peek().setLevelCost(levelCost);
            return this;
        }

        public Builder frame(int frame) {
            this.stack.peek().setFrame(Mth.m_14045_((int)frame, (int)0, (int)2));
            return this;
        }

        public Builder manaCost(float manaCost) {
            this.stack.peek().getSpellInstance().setManaCost(manaCost);
            return this;
        }

        public Builder noManaCost() {
            return this.manaCost(0.0f);
        }

        public Builder addParameter(CtxVar<?> ctxVar) {
            this.stack.peek().getSpellInstance().addParameter(ctxVar);
            return this;
        }

        public Builder goalFrame() {
            return this.frame(2);
        }

        public Builder challengeFrame() {
            return this.frame(1);
        }

        public Builder hiddenRequirements(Requirement ... requirements) {
            Arrays.stream(requirements).forEach(this::hiddenRequirement);
            return this;
        }

        private Builder hiddenRequirement(Requirement requirement) {
            this.stack.peek().addHiddenRequirement(requirement);
            return this;
        }

        public Builder learnRequirements(Requirement ... requirements) {
            Arrays.stream(requirements).forEach(this::learnRequirement);
            return this;
        }

        private Builder learnRequirement(Requirement requirement) {
            this.stack.peek().addLearnRequirement(requirement);
            return this;
        }

        public SpellTree finish() {
            return new SpellTree(this.root, this.title, this.icon != null ? this.icon : ((Spell)this.root.getSpellInstance().getSpell().get()).getIcon());
        }
    }
}

