/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.registers.SpellTrees;
import de.cas_ual_ty.spells.requirement.WrappedRequirement;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.LevelAccessor;

public class ProgressionHelper {
    public static List<SpellTree> stripSpellTrees(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access, Registry<SpellTree> registry) {
        LinkedList<SpellTree> strippedSkillTrees = new LinkedList<SpellTree>();
        if (spellProgressionHolder.getPlayer().m_7500_()) {
            registry.m_6579_().stream().map(Map.Entry::getValue).map(SpellTree::copy).forEach(strippedSkillTrees::add);
        } else {
            for (Map.Entry entry : registry.m_6579_()) {
                SpellTree spellTree0 = (SpellTree)entry.getValue();
                if (spellTree0.getRoot() == null || !spellTree0.getRoot().passesHidden(spellProgressionHolder, access)) continue;
                SpellTree stripped = spellTree0.copy();
                LinkedList<SpellNode> visibleNodes = new LinkedList<SpellNode>();
                stripped.forEach(spellNode -> {
                    if (spellProgressionHolder.getSpellStatus(spellNode.getNodeId()).isVisible()) {
                        visibleNodes.add((SpellNode)spellNode);
                    }
                });
                if (!visibleNodes.contains(stripped.getRoot())) {
                    visibleNodes.add(stripped.getRoot());
                    if (visibleNodes.size() == 1) {
                        stripped.getRoot().getChildren().clear();
                        strippedSkillTrees.add(stripped);
                        continue;
                    }
                }
                for (SpellNode spellNode2 : visibleNodes.stream().toList()) {
                    SpellNode parent;
                    while ((parent = spellNode2.getParent()) != null && !visibleNodes.contains(parent)) {
                        visibleNodes.add(parent);
                        spellNode2 = parent;
                    }
                }
                LinkedList invisibleNodes = new LinkedList();
                stripped.forEach(spellNode -> {
                    if (!visibleNodes.contains(spellNode) && !spellNode.passesHidden(spellProgressionHolder, access)) {
                        invisibleNodes.add(spellNode);
                    }
                });
                invisibleNodes.forEach(spellNode -> spellNode.getParent().getChildren().remove(spellNode));
                stripped.forEach(spellNode -> {
                    if (!visibleNodes.contains(spellNode)) {
                        boolean fullyLinked = ProgressionHelper.isFullyLinked(spellNode, spellProgressionHolder.getProgression());
                        if (fullyLinked) {
                            spellNode.getChildren().clear();
                        } else {
                            invisibleNodes.add(spellNode);
                        }
                    }
                });
                invisibleNodes.forEach(spellNode -> spellNode.getParent().getChildren().remove(spellNode));
                strippedSkillTrees.add(stripped);
            }
        }
        strippedSkillTrees.forEach(tree -> tree.forEach(node -> {
            node.setHiddenRequirements(node.getHiddenRequirements().stream().map(r -> WrappedRequirement.wrap(r, spellProgressionHolder, access, true)).collect(Collectors.toList()));
            node.setLearnRequirements(node.getLearnRequirements().stream().map(r -> WrappedRequirement.wrap(r, spellProgressionHolder, access, false)).collect(Collectors.toList()));
        }));
        return strippedSkillTrees;
    }

    public static List<SpellTree> getStrippedSpellTrees(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        Registry<SpellTree> registry = SpellTrees.getRegistry((LevelAccessor)spellProgressionHolder.getPlayer().f_19853_);
        return ProgressionHelper.stripSpellTrees(spellProgressionHolder, access, registry);
    }

    public static boolean isFullyLinked(SpellNode spellNode, Map<SpellNodeId, SpellStatus> progression) {
        SpellNode parent = spellNode;
        while ((parent = parent.getParent()) != null) {
            if (progression.getOrDefault(parent.getNodeId(), SpellStatus.LOCKED).isAvailable()) continue;
            return false;
        }
        return true;
    }

    public static boolean tryBuySpell(SpellProgressionHolder spellProgressionHolder, SpellProgressionMenu menu, SpellNodeId nodeId) {
        Player player = menu.player;
        AtomicBoolean found = new AtomicBoolean(false);
        Registry<SpellTree> registry = SpellTrees.getRegistry((LevelAccessor)spellProgressionHolder.getPlayer().f_19853_);
        menu.spellTrees.stream().filter(tree -> tree.getId().equals((Object)nodeId.treeId())).findFirst().ifPresent(spellTree -> {
            SpellNode spellNode = spellTree.findNode(nodeId.nodeId());
            if (spellNode != null && spellNode.canLearn(spellProgressionHolder, menu.access)) {
                found.set(true);
                if (!player.m_7500_()) {
                    player.m_6749_(-spellNode.getLevelCost());
                }
                spellNode.onSpellLearned(spellProgressionHolder, menu.access);
            }
        });
        return found.get();
    }
}

