/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.requirement.RequirementType;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spell.icon.SpellIcon;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SpellTreeSerializer {
    private static byte TYPE_FINISH = 0;
    private static byte TYPE_SPELL = 1;
    private static byte TYPE_UP = (byte)2;

    public static void encodeTree(SpellTree spellTree, Registry<Spell> registry, FriendlyByteBuf buf) {
        buf.m_130085_(spellTree.getId());
        buf.m_130083_(spellTree.getTitle());
        SpellIcon.iconToBuf(buf, spellTree.getIcon());
        SpellNode spellNode = spellTree.getRoot();
        SpellTreeSerializer.encodeTreeRec(spellNode, registry, buf);
        buf.writeByte((int)TYPE_FINISH);
    }

    private static void encodeTreeRec(SpellNode spellNode, Registry<Spell> registry, FriendlyByteBuf buf) {
        buf.writeByte((int)TYPE_SPELL);
        SpellTreeSerializer.encodeNode(spellNode, registry, buf);
        for (SpellNode child : spellNode.getChildren()) {
            SpellTreeSerializer.encodeTreeRec(child, registry, buf);
        }
        buf.writeByte((int)TYPE_UP);
    }

    private static void encodeRequirements(List<Requirement> list, FriendlyByteBuf buf) {
        buf.writeInt(list.size());
        list.forEach(requirement -> RequirementType.writeToBuf(buf, requirement));
    }

    private static void encodeNode(SpellNode spellNode, Registry<Spell> registry, FriendlyByteBuf buf) {
        buf.m_130085_((ResourceLocation)spellNode.getSpellInstance().getSpell().m_203439_().map(ResourceKey::m_135782_, arg_0 -> registry.m_7981_(arg_0)));
        buf.writeInt(spellNode.getLevelCost());
        SpellTreeSerializer.encodeRequirements(spellNode.getHiddenRequirements(), buf);
        SpellTreeSerializer.encodeRequirements(spellNode.getLearnRequirements(), buf);
        buf.m_130085_(spellNode.getNodeId().treeId());
        buf.writeInt(spellNode.getNodeId().nodeId());
        buf.writeByte(spellNode.getFrame());
        buf.writeFloat(spellNode.getSpellInstance().getManaCost());
    }

    public static SpellTree decodeTree(Registry<Spell> registry, FriendlyByteBuf buf) {
        byte next;
        ResourceLocation id = buf.m_130281_();
        Component title = buf.m_130238_();
        SpellIcon icon = SpellIcon.iconFromBuf(buf);
        SpellTree.Builder builder = SpellTree.builder(title);
        while ((next = buf.readByte()) != TYPE_FINISH) {
            if (next == TYPE_SPELL) {
                builder.add(SpellTreeSerializer.decodeNode(registry, buf));
                continue;
            }
            if (next == TYPE_UP) {
                builder.leaf();
                continue;
            }
            throw new IllegalStateException();
        }
        return builder.icon(icon).finish().setId(id);
    }

    private static List<Requirement> decodeRequirements(FriendlyByteBuf buf) {
        int size = buf.readInt();
        LinkedList<Requirement> list = new LinkedList<Requirement>();
        for (int i = 0; i < size; ++i) {
            list.add(RequirementType.readFromBuf(buf));
        }
        return list;
    }

    public static SpellNode decodeNode(Registry<Spell> registry, FriendlyByteBuf buf) {
        Holder spell = registry.m_206081_(ResourceKey.m_135785_(Spells.REGISTRY_KEY, (ResourceLocation)buf.m_130281_()));
        int levelCost = buf.readInt();
        List<Requirement> hiddenRequirements = SpellTreeSerializer.decodeRequirements(buf);
        List<Requirement> learnRequirements = SpellTreeSerializer.decodeRequirements(buf);
        SpellNodeId id = new SpellNodeId(buf.m_130281_(), buf.readInt());
        byte frame = buf.readByte();
        float manaCost = buf.readFloat();
        return new SpellNode(id, new SpellInstance((Holder<Spell>)spell, manaCost), levelCost, hiddenRequirements, learnRequirements, (int)frame);
    }
}

