/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.RequirementTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.SpellIconTypes;
import de.cas_ual_ty.spells.registers.SpellTrees;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.requirement.RequirementType;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spell.action.SpellAction;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.icon.SpellIcon;
import de.cas_ual_ty.spells.spell.icon.SpellIconType;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.variable.CtxVar;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ExtraCodecs;

public class SpellsCodecs {
    public static Codec<Holder<Spell>> SPELL;
    public static Codec<Holder<SpellTree>> SPELL_TREE;
    public static Codec<RequirementType<?>> REQUIREMENT_TYPE;
    public static Codec<SpellActionType<?>> SPELL_ACTION_TYPE;
    public static Codec<CtxVarType<?>> CTX_VAR_TYPE;
    public static Codec<SpellIconType<?>> SPELL_ICON_TYPE;
    public static Codec<ITargetType<?>> TARGET_TYPE;
    public static Codec<Requirement> REQUIREMENT;
    public static Codec<SpellAction> SPELL_ACTION;
    public static Codec<CtxVar<?>> CTX_VAR;
    public static Codec<SpellIcon> SPELL_ICON;
    public static Codec<SpellNode> SPELL_NODE;
    public static Codec<SpellTree> SPELL_TREE_CONTENTS;
    public static Codec<Spell> SPELL_CONTENTS;
    public static Codec<Component> COMPONENT;
    public static Codec<Map<String, String>> STRING_MAP;

    public static void makeCodecs() {
        SPELL = ExtraCodecs.m_184415_(() -> RegistryFileCodec.m_135592_(Spells.REGISTRY_KEY, (Codec)ExtraCodecs.m_184415_(() -> SPELL_CONTENTS), (boolean)false));
        SPELL_TREE = ExtraCodecs.m_184415_(() -> RegistryFixedCodec.m_206740_(SpellTrees.REGISTRY_KEY));
        REQUIREMENT_TYPE = ExtraCodecs.m_184415_(() -> RequirementTypes.REGISTRY.get().getCodec());
        CTX_VAR_TYPE = ExtraCodecs.m_184415_(() -> CtxVarTypes.REGISTRY.get().getCodec());
        SPELL_ACTION_TYPE = ExtraCodecs.m_184415_(() -> SpellActionTypes.REGISTRY.get().getCodec());
        SPELL_ICON_TYPE = ExtraCodecs.m_184415_(() -> SpellIconTypes.REGISTRY.get().getCodec());
        TARGET_TYPE = ExtraCodecs.m_184415_(() -> TargetTypes.REGISTRY.get().getCodec());
        REQUIREMENT = ExtraCodecs.m_184415_(() -> REQUIREMENT_TYPE.dispatch("type", Requirement::getType, RequirementType::getCodec));
        SPELL_ACTION = ExtraCodecs.m_184415_(() -> SPELL_ACTION_TYPE.dispatch("type", SpellAction::getType, SpellActionType::getCodec));
        CTX_VAR = ExtraCodecs.m_184415_(() -> CTX_VAR_TYPE.dispatch("type", CtxVar::getType, CtxVarType::getCodec));
        SPELL_ICON = ExtraCodecs.m_184415_(() -> SPELL_ICON_TYPE.dispatch("type", SpellIcon::getType, SpellIconType::getCodec));
        SPELL_NODE = ExtraCodecs.m_184415_(() -> RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_184415_(() -> SPELL).fieldOf("n1/spell_id").forGetter(node -> node.getSpellInstance().getSpell()), (App)Codec.optionalField((String)"n7/mana_cost", (Codec)Codec.FLOAT).xmap(o -> o.orElse(Float.valueOf(-1.0f)), manaCost -> manaCost.floatValue() >= 0.0f ? Optional.of(manaCost) : Optional.empty()).forGetter(node -> Float.valueOf(node.getSpellInstance().getManaCost())), (App)Codec.optionalField((String)"n8/spell_parameters", (Codec)ExtraCodecs.m_184415_(() -> CTX_VAR).listOf()).xmap(o -> o.orElse(new LinkedList()), p -> Optional.of(p).map(l -> l.isEmpty() ? null : l)).forGetter(node -> node.getSpellInstance().getParameters()), (App)Codec.INT.fieldOf("n4/level_cost").forGetter(SpellNode::getLevelCost), (App)Codec.optionalField((String)"n5/hidden_requirements", (Codec)REQUIREMENT.listOf()).xmap(o -> o.orElse(new LinkedList()), r -> Optional.of(r).map(l -> l.isEmpty() ? null : l)).forGetter(SpellNode::getHiddenRequirements), (App)Codec.optionalField((String)"n6/learn_requirements", (Codec)REQUIREMENT.listOf()).xmap(o -> o.orElse(new LinkedList()), r -> Optional.of(r).map(l -> l.isEmpty() ? null : l)).forGetter(SpellNode::getLearnRequirements), (App)ExtraCodecs.m_184415_(() -> SPELL_NODE).listOf().fieldOf("n9/child_nodes").forGetter(SpellNode::getChildren), (App)Codec.optionalField((String)"n2/node_id", (Codec)Codec.INT).xmap(o -> o.map(i -> new SpellNodeId(null, (int)i)).orElse(null), nodeId -> Optional.ofNullable(nodeId).map(SpellNodeId::nodeId)).forGetter(SpellNode::getNodeId), (App)Codec.optionalField((String)"n3/node_frame", (Codec)Codec.intRange((int)0, (int)2)).xmap(o -> o.orElse(0), f -> Optional.of(f).map(i -> i <= 0 ? null : i)).forGetter(SpellNode::getFrame)).apply((Applicative)instance, (spell, manaCost, variables, levelCost, hiddenRequirements, learnRequirements, children, id, frame) -> new SpellNode((SpellNodeId)id, new SpellInstance((Holder<Spell>)spell, manaCost.floatValue(), (List<CtxVar<?>>)variables), (int)levelCost, (List<Requirement>)hiddenRequirements, (List<Requirement>)learnRequirements, (List<SpellNode>)children, (int)frame))));
        SPELL_TREE_CONTENTS = ExtraCodecs.m_184415_(() -> RecordCodecBuilder.create(instance -> instance.group((App)SPELL_NODE.fieldOf("t3/root_node").forGetter(SpellTree::getRoot), (App)COMPONENT.fieldOf("t1/title").forGetter(SpellTree::getTitle), (App)SPELL_ICON.fieldOf("t2/icon").forGetter(SpellTree::getIcon)).apply((Applicative)instance, SpellTree::new)));
        SPELL_CONTENTS = ExtraCodecs.m_184415_(() -> RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_184415_(() -> SPELL_ACTION).listOf().fieldOf("s7/spell_actions").forGetter(Spell::getSpellActions), (App)ExtraCodecs.m_184415_(() -> SPELL_ICON).fieldOf("s2/icon").forGetter(Spell::getIcon), (App)COMPONENT.fieldOf("s1/title").forGetter(Spell::getTitle), (App)COMPONENT.listOf().fieldOf("s4/tooltip").forGetter(Spell::getTooltip), (App)Codec.FLOAT.fieldOf("s3/mana_cost").xmap(f -> Float.valueOf(Math.max(0.0f, f.floatValue())), f -> Float.valueOf(Math.max(0.0f, f.floatValue()))).forGetter(Spell::getManaCost), (App)CTX_VAR.listOf().fieldOf("s6/spell_parameters").forGetter(Spell::getParameters), (App)Codec.STRING.listOf().fieldOf("s5/spell_events").forGetter(Spell::getEventsList)).apply((Applicative)instance, Spell::new)));
        COMPONENT = ExtraCodecs.m_184415_(() -> new PrimitiveCodec<Component>(){

            public <T> DataResult<Component> read(DynamicOps<T> ops, T input0) {
                if (ops == JsonOps.INSTANCE || ops == JsonOps.COMPRESSED || ops instanceof RegistryOps) {
                    JsonElement input = (JsonElement)input0;
                    return DataResult.success((Object)Component.Serializer.m_130691_((JsonElement)input));
                }
                return DataResult.error((String)"Codec only works on JsonOps");
            }

            public <T> T write(DynamicOps<T> ops, Component value) {
                if (ops == JsonOps.INSTANCE || ops == JsonOps.COMPRESSED || ops instanceof RegistryOps) {
                    return (T)Component.Serializer.m_130716_((Component)value);
                }
                return (T)ops.empty();
            }
        });
        STRING_MAP = new PrimitiveCodec<Map<String, String>>(){

            public <T> DataResult<Map<String, String>> read(DynamicOps<T> ops, T input0) {
                if (ops == JsonOps.INSTANCE || ops == JsonOps.COMPRESSED || ops instanceof RegistryOps) {
                    JsonElement input = (JsonElement)input0;
                    if (input.isJsonObject()) {
                        JsonObject jsonMap = input.getAsJsonObject();
                        HashMap<String, String> map = new HashMap<String, String>();
                        for (String key : jsonMap.keySet()) {
                            JsonElement value = jsonMap.get(key);
                            if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                                map.put(key, value.getAsString());
                                continue;
                            }
                            return DataResult.error((String)("Value with key " + key + " is not a string"));
                        }
                        return DataResult.success(map);
                    }
                    DataResult.error((String)"Not a json object");
                }
                return DataResult.error((String)"Codec only works on JsonOps");
            }

            public <T> T write(DynamicOps<T> ops, Map<String, String> value) {
                if (ops == JsonOps.INSTANCE || ops == JsonOps.COMPRESSED || ops instanceof RegistryOps) {
                    JsonObject jsonMap = new JsonObject();
                    value.forEach((arg_0, arg_1) -> ((JsonObject)jsonMap).addProperty(arg_0, arg_1));
                    return (T)jsonMap;
                }
                return (T)ops.empty();
            }
        };
    }
}

