/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.client.SpellsClientUtil;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SpellsUtil {
    public static final Optional<ItemStack> EMPTY_ITEMSTACK_OPTIONAL = Optional.of(ItemStack.f_41583_);
    public static final Optional<List<ItemStack>> EMPTY_ITEMSTACK_LIST_OPTIONAL = Optional.of(ImmutableList.of((Object)ItemStack.f_41583_));
    public static final Container EMPTY_CONTAINER = new SimpleContainer(0);
    public static final RandomSource RANDOM = RandomSource.m_216327_();

    public static HitResult rayTrace(Level level, Entity source, double maxDist, Predicate<Entity> filter, float bbInflation, ClipContext.Block block, ClipContext.Fluid fluid) {
        BlockHitResult blockHitResult = SpellsUtil.rayTraceBlock(level, source, maxDist, block, fluid);
        EntityHitResult entityHitResult = SpellsUtil.rayTraceEntity(level, source, maxDist, filter, bbInflation);
        if (entityHitResult == null) {
            return blockHitResult;
        }
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return entityHitResult;
        }
        Vec3 position = source.m_20182_();
        double blockDist = blockHitResult.m_82448_(source);
        double entityDist = entityHitResult.m_82448_(source);
        if (entityDist <= blockDist) {
            return entityHitResult;
        }
        return blockHitResult;
    }

    public static BlockHitResult rayTraceBlock(Level level, Entity source, double maxDist, ClipContext.Block block, ClipContext.Fluid fluid) {
        double maxDistSqr = maxDist * maxDist;
        Vec3 start = source.m_146892_();
        Vec3 direction = source.m_20252_(1.0f).m_82541_();
        Vec3 end = start.m_82549_(direction.m_82490_(maxDist));
        return level.m_45547_(new ClipContext(start, end, block, fluid, source));
    }

    @Nullable
    public static EntityHitResult rayTraceEntity(Level level, Entity source, double maxDist, Predicate<Entity> filter, float bbInflation) {
        double maxDistSqr = maxDist * maxDist;
        double currentDistance = Double.MAX_VALUE;
        Entity currentEntity = null;
        Vec3 start = source.m_146892_();
        Vec3 direction = source.m_20252_(1.0f).m_82541_();
        Vec3 end = start.m_82549_(direction.m_82490_(maxDist));
        for (Entity entity : level.m_45933_(source, AABB.m_165882_((Vec3)start, (double)maxDistSqr, (double)maxDistSqr, (double)maxDistSqr))) {
            double distance;
            AABB aabb;
            Optional optional;
            if (!filter.test(entity) || !(optional = (aabb = entity.m_20191_().m_82400_((double)bbInflation)).m_82371_(start, end)).isPresent() || !((distance = start.m_82557_((Vec3)optional.get())) < currentDistance)) continue;
            currentEntity = entity;
            currentDistance = distance;
        }
        return currentEntity == null ? null : new EntityHitResult(currentEntity);
    }

    public static void addPotionRecipes(Potion base, Potion p, @Nullable Potion strongP, @Nullable Potion longP, Item ingredient, @Nullable Potion badP, @Nullable Potion badStrongP, @Nullable Potion badLongP, @Nullable Item badIngredient) {
        SpellsUtil.addPotionRecipe(ingredient, base, p);
        if (badP != null && badIngredient != null) {
            SpellsUtil.addPotionRecipe(badIngredient, p, badP);
            if (badStrongP != null) {
                SpellsUtil.addPotionRecipe(Items.f_42525_, badP, badStrongP);
            }
            if (badLongP != null) {
                SpellsUtil.addPotionRecipe(Items.f_42451_, badP, badLongP);
            }
        }
        if (strongP != null) {
            SpellsUtil.addPotionRecipe(Items.f_42525_, p, strongP);
            if (badStrongP != null && badIngredient != null) {
                SpellsUtil.addPotionRecipe(badIngredient, strongP, badStrongP);
            }
        }
        if (longP != null) {
            SpellsUtil.addPotionRecipe(Items.f_42451_, p, longP);
            if (badLongP != null && badIngredient != null) {
                SpellsUtil.addPotionRecipe(badIngredient, longP, badLongP);
            }
        }
    }

    public static void addPotionRecipe(Item ingredient, Potion from, Potion to) {
        PotionBrewing.m_43513_((Potion)from, (Item)ingredient, (Potion)to);
    }

    public static boolean isEnchantingTable(Block block) {
        return block != null && SpellsUtil.isEnchantingTable(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    public static boolean isEnchantingTable(ResourceLocation key) {
        return key != null && ((List)SpellsConfig.ENCHANTING_TABLE.get()).stream().anyMatch(rl -> rl.equals(key.toString()));
    }

    public static Level getClientLevel() {
        return (Level)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> SpellsClientUtil.getClientLevel());
    }

    public static <E extends Enum<E>> Codec<E> namedEnumCodec(Function<String, E> stringToEnum, Function<E, String> enumToString) {
        return Codec.STRING.xmap(stringToEnum, enumToString);
    }

    public static <E extends Enum<E>> Codec<E> idEnumCodec(Function<Integer, E> idToEnum) {
        return Codec.INT.xmap(idToEnum, Enum::ordinal);
    }

    public static UUID generateUUIDFromName(String name) {
        return UUID.nameUUIDFromBytes(("spells_and_shields_" + name).getBytes(StandardCharsets.UTF_8));
    }

    public static UUID uuidFromString(String s) {
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String operationToString(AttributeModifier.Operation op) {
        return switch (op) {
            case AttributeModifier.Operation.ADDITION -> "addition";
            case AttributeModifier.Operation.MULTIPLY_BASE -> "multiply_base";
            case AttributeModifier.Operation.MULTIPLY_TOTAL -> "multiply_total";
            default -> null;
        };
    }

    public static AttributeModifier.Operation operationFromString(String s) {
        return switch (s) {
            case "addition" -> AttributeModifier.Operation.ADDITION;
            case "multiply_base" -> AttributeModifier.Operation.MULTIPLY_BASE;
            case "multiply_total" -> AttributeModifier.Operation.MULTIPLY_TOTAL;
            default -> null;
        };
    }

    public static String blockToString(ClipContext.Block op) {
        return switch (op) {
            case ClipContext.Block.COLLIDER -> "collider";
            case ClipContext.Block.OUTLINE -> "outline";
            case ClipContext.Block.VISUAL -> "visual";
            case ClipContext.Block.FALLDAMAGE_RESETTING -> "falldamage_resetting";
            default -> null;
        };
    }

    public static ClipContext.Block blockFromString(String s) {
        return switch (s) {
            case "collider" -> ClipContext.Block.COLLIDER;
            case "outline" -> ClipContext.Block.OUTLINE;
            case "visual" -> ClipContext.Block.VISUAL;
            case "falldamage_resetting" -> ClipContext.Block.FALLDAMAGE_RESETTING;
            default -> null;
        };
    }

    public static String fluidToString(ClipContext.Fluid op) {
        return switch (op) {
            case ClipContext.Fluid.NONE -> "none";
            case ClipContext.Fluid.SOURCE_ONLY -> "source_only";
            case ClipContext.Fluid.ANY -> "any";
            case ClipContext.Fluid.WATER -> "water";
            default -> null;
        };
    }

    public static ClipContext.Fluid fluidFromString(String s) {
        return switch (s) {
            case "none" -> ClipContext.Fluid.NONE;
            case "source_only" -> ClipContext.Fluid.SOURCE_ONLY;
            case "any" -> ClipContext.Fluid.ANY;
            case "water" -> ClipContext.Fluid.WATER;
            default -> null;
        };
    }

    public static <T> DynamicCtxVar<String> objectToString(T object, IForgeRegistry<T> registry) {
        return ((CtxVarType)CtxVarTypes.STRING.get()).immediate(registry.getKey(object).toString());
    }

    public static <T> Optional<T> stringToObject(SpellContext ctx, DynamicCtxVar<String> s, IForgeRegistry<T> registry) {
        return s.getValue(ctx).map(id -> registry.getValue(new ResourceLocation(id)));
    }

    public static BlockState tagToState(Block block, CompoundTag tag) {
        BlockState blockState = block.m_49966_();
        for (Property p : blockState.m_61147_()) {
            SpellsUtil.addPropertyFromTag(blockState, p, tag);
        }
        return blockState;
    }

    private static <X extends Comparable<X>> void addPropertyFromTag(BlockState blockState, Property<X> p, CompoundTag tag) {
        p.m_61705_().decode((DynamicOps)NbtOps.f_128958_, (Object)tag).result().ifPresent(pair -> blockState.m_61124_(p, ((Property.Value)pair.getFirst()).f_61713_()));
    }

    public static CompoundTag stateToTag(StateHolder<?, ?> stateHolder) {
        CompoundTag tag = new CompoundTag();
        for (Property p : stateHolder.m_61147_()) {
            SpellsUtil.addPropertyToTag(stateHolder, tag, p);
        }
        return tag;
    }

    private static <X extends Comparable<X>> void addPropertyToTag(StateHolder<?, ?> stateHolder, CompoundTag tag, Property<X> p) {
        p.m_61705_().encodeStart((DynamicOps)NbtOps.f_128958_, (Object)p.m_61694_(stateHolder)).result().ifPresent(element -> tag.m_128365_(p.m_61708_(), element));
    }
}

