/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells;

import com.mojang.brigadier.CommandDispatcher;
import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.command.SpellArgument;
import de.cas_ual_ty.spells.command.SpellCommand;
import de.cas_ual_ty.spells.effect.ExtraManaMobEffect;
import de.cas_ual_ty.spells.effect.InstantManaMobEffect;
import de.cas_ual_ty.spells.effect.ManaMobEffect;
import de.cas_ual_ty.spells.effect.SimpleEffect;
import de.cas_ual_ty.spells.enchantment.MagicProtectionEnchantment;
import de.cas_ual_ty.spells.enchantment.ManaBladeEnchantment;
import de.cas_ual_ty.spells.enchantment.ManaRegenEnchantment;
import de.cas_ual_ty.spells.enchantment.ManaShieldEnchantment;
import de.cas_ual_ty.spells.enchantment.MaxManaEnchantment;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.requirement.AdvancementRequirement;
import de.cas_ual_ty.spells.requirement.BookshelvesRequirement;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import de.cas_ual_ty.spells.requirement.ItemRequirement;
import de.cas_ual_ty.spells.requirement.WrappedRequirement;
import de.cas_ual_ty.spells.spell.ITickedDataSpell;
import de.cas_ual_ty.spells.spell.base.HomingSpellProjectile;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import de.cas_ual_ty.spells.spelldata.ISpellDataType;
import de.cas_ual_ty.spells.spelldata.SimpleTickedSpellData;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class SpellsRegistries {
    public static Supplier<IForgeRegistry<IRequirementType<?>>> REQUIREMENTS_REGISTRY;
    private static final DeferredRegister<IRequirementType<?>> REQUIREMENTS;
    public static Supplier<IForgeRegistry<ISpellDataType<?>>> SPELL_DATA_REGISTRY;
    private static final DeferredRegister<ISpellDataType<?>> SPELL_DATA;
    private static final DeferredRegister<Block> BLOCKS;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<Attribute> ATTRIBUTES;
    private static final DeferredRegister<Enchantment> ENCHANTMENTS;
    private static final DeferredRegister<MobEffect> MOB_EFFECTS;
    private static final DeferredRegister<Potion> POTIONS;
    private static final DeferredRegister<MenuType<?>> CONTAINER_TYPES;
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES;
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> ARGUMENT_TYPES;
    public static final RegistryObject<ArgumentTypeInfo<?, ?>> SPELL_ARGUMENT_TYPE;
    public static final EnchantmentCategory SHIELD_ENCHANTMENT_CATEGORY;
    public static final EnchantmentCategory SWORD_OR_AXE_ENCHANTMENT_CATEGORY;
    public static final RegistryObject<IRequirementType<WrappedRequirement>> WRAPPED_REQUIREMENT;
    public static final RegistryObject<IRequirementType<BookshelvesRequirement>> BOOKSHELVES_REQUIREMENT;
    public static final RegistryObject<IRequirementType<AdvancementRequirement>> ADVANCEMENT_REQUIREMENT;
    public static final RegistryObject<IRequirementType<ItemRequirement>> ITEM_REQUIREMENT;
    public static final RegistryObject<ISpellDataType<SimpleTickedSpellData>> FLAMETHROWER_DATA;
    public static final RegistryObject<ISpellDataType<SimpleTickedSpellData>> GHAST_DATA;
    public static final RegistryObject<RangedAttribute> MAX_MANA_ATTRIBUTE;
    public static final RegistryObject<RangedAttribute> MANA_REGENERATION_ATTRIBUTE;
    public static final RegistryObject<Enchantment> MAGIC_PROTECTION_ENCHANTMENT;
    public static final RegistryObject<Enchantment> MANA_BLADE_ENCHANTMENT;
    public static final RegistryObject<Enchantment> MANA_SHIELD_ENCHANTMENT;
    public static final RegistryObject<MaxManaEnchantment> MAX_MANA_ENCHANTMENT;
    public static final RegistryObject<ManaRegenEnchantment> MANA_REGENERATION_ENCHANTMENT;
    public static final RegistryObject<MobEffect> INSTANT_MANA_EFFECT;
    public static final RegistryObject<MobEffect> MANA_BOMB_EFFECT;
    public static final RegistryObject<MobEffect> REPLENISHMENT_EFFECT;
    public static final RegistryObject<MobEffect> LEAKING_MOB_EFFECT;
    public static final RegistryObject<MobEffect> MANA_BOOST_EFFECT;
    public static final RegistryObject<MobEffect> EXTRA_MANA_EFFECT;
    public static final RegistryObject<MobEffect> SILENCE_EFFECT;
    public static final RegistryObject<MobEffect> MAGIC_IMMUNE_EFFECT;
    public static final RegistryObject<Potion> INSTANT_MANA;
    public static final RegistryObject<Potion> STRONG_INSTANT_MANA;
    public static final RegistryObject<Potion> MANA_BOMB;
    public static final RegistryObject<Potion> STRONG_MANA_BOMB;
    public static final RegistryObject<Potion> REPLENISHMENT;
    public static final RegistryObject<Potion> LONG_REPLENISHMENT;
    public static final RegistryObject<Potion> STRONG_REPLENISHMENT;
    public static final RegistryObject<Potion> LEAKING;
    public static final RegistryObject<Potion> LONG_LEAKING;
    public static final RegistryObject<Potion> STRONG_LEAKING;
    public static final RegistryObject<MenuType<SpellProgressionMenu>> SPELL_PROGRESSION_MENU;
    public static final RegistryObject<EntityType<SpellProjectile>> SPELL_PROJECTILE;
    public static final RegistryObject<EntityType<HomingSpellProjectile>> HOMING_SPELL_PROJECTILE;

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SpellsRegistries::newRegistry);
        REQUIREMENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        SPELL_DATA.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MOB_EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        POTIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ATTRIBUTES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENCHANTMENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINER_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENTITY_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ARGUMENT_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static void newRegistry(NewRegistryEvent event) {
        REQUIREMENTS_REGISTRY = event.create(new RegistryBuilder().setMaxID(256).setName(new ResourceLocation("spells_and_shields", "requirements")));
        SPELL_DATA_REGISTRY = event.create(new RegistryBuilder().setMaxID(256).setName(new ResourceLocation("spells_and_shields", "spell_data")));
    }

    public static void addPotionRecipes() {
        SpellsUtil.addPotionRecipes(Potions.f_43602_, (Potion)INSTANT_MANA.get(), (Potion)STRONG_INSTANT_MANA.get(), null, Items.f_42290_, (Potion)MANA_BOMB.get(), (Potion)STRONG_MANA_BOMB.get(), null, Items.f_42592_);
        SpellsUtil.addPotionRecipes(Potions.f_43602_, (Potion)REPLENISHMENT.get(), (Potion)STRONG_REPLENISHMENT.get(), (Potion)LONG_REPLENISHMENT.get(), Items.f_42300_, null, null, null, null);
        SpellsUtil.addPotionRecipes(Potions.f_43602_, (Potion)LEAKING.get(), (Potion)STRONG_LEAKING.get(), (Potion)LONG_LEAKING.get(), Items.f_42358_, null, null, null, null);
    }

    private static void entityAttributeModification(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)MAX_MANA_ATTRIBUTE.get());
        event.add(EntityType.f_20532_, (Attribute)MANA_REGENERATION_ATTRIBUTE.get());
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        SpellCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private static void livingHurt(LivingHurtEvent event) {
        if (!event.getEntity().f_19853_.f_46443_ && event.getSource().m_19387_() && !event.getSource().m_19378_() && event.getEntity().m_21023_((MobEffect)MAGIC_IMMUNE_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    public static void registerEvents() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SpellsRegistries::entityAttributeModification);
        MinecraftForge.EVENT_BUS.addListener(SpellsRegistries::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(SpellsRegistries::livingHurt);
    }

    static {
        REQUIREMENTS = DeferredRegister.create((ResourceLocation)new ResourceLocation("spells_and_shields", "requirements"), (String)"spells_and_shields");
        SPELL_DATA = DeferredRegister.create((ResourceLocation)new ResourceLocation("spells_and_shields", "spell_data"), (String)"spells_and_shields");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"spells_and_shields");
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"spells_and_shields");
        ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"spells_and_shields");
        ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"spells_and_shields");
        MOB_EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"spells_and_shields");
        POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"spells_and_shields");
        CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"spells_and_shields");
        ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"spells_and_shields");
        ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"spells_and_shields");
        SPELL_ARGUMENT_TYPE = ARGUMENT_TYPES.register("spell", () -> ArgumentTypeInfos.registerByClass(SpellArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235449_(SpellArgument::spell)));
        SHIELD_ENCHANTMENT_CATEGORY = EnchantmentCategory.create((String)"SHIELD", item -> item instanceof ShieldItem);
        SWORD_OR_AXE_ENCHANTMENT_CATEGORY = EnchantmentCategory.create((String)"SWORD_OR_AXE", item -> item instanceof AxeItem || item instanceof SwordItem);
        WRAPPED_REQUIREMENT = REQUIREMENTS.register("client_wrap", () -> WrappedRequirement::new);
        BOOKSHELVES_REQUIREMENT = REQUIREMENTS.register("bookshelves", () -> BookshelvesRequirement::new);
        ADVANCEMENT_REQUIREMENT = REQUIREMENTS.register("advancement", () -> AdvancementRequirement::new);
        ITEM_REQUIREMENT = REQUIREMENTS.register("item", () -> ItemRequirement::new);
        FLAMETHROWER_DATA = SPELL_DATA.register("flamethrower", () -> ITickedDataSpell.makeDataType(Spells.FLAMETHROWER));
        GHAST_DATA = SPELL_DATA.register("ghast", () -> ITickedDataSpell.makeDataType(Spells.GHAST));
        MAX_MANA_ATTRIBUTE = ATTRIBUTES.register("generic.max_mana", () -> (RangedAttribute)new RangedAttribute("attribute.name.generic.max_mana", 20.0, 0.0, 1024.0).m_22084_(true));
        MANA_REGENERATION_ATTRIBUTE = ATTRIBUTES.register("generic.mana_regeneration", () -> (RangedAttribute)new RangedAttribute("attribute.name.generic.mana_regen", 1.0, 0.0, 50.0).m_22084_(true));
        MAGIC_PROTECTION_ENCHANTMENT = ENCHANTMENTS.register("magic_protection", () -> new MagicProtectionEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET));
        MANA_BLADE_ENCHANTMENT = ENCHANTMENTS.register("mana_blade", () -> new ManaBladeEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlot.MAINHAND));
        MANA_SHIELD_ENCHANTMENT = ENCHANTMENTS.register("mana_shield", () -> new ManaShieldEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlot.OFFHAND));
        MAX_MANA_ENCHANTMENT = ENCHANTMENTS.register("max_mana", () -> new MaxManaEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET));
        MANA_REGENERATION_ENCHANTMENT = ENCHANTMENTS.register("mana_regeneration", () -> new ManaRegenEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET));
        INSTANT_MANA_EFFECT = MOB_EFFECTS.register("instant_mana", () -> new InstantManaMobEffect(MobEffectCategory.BENEFICIAL, 440253));
        MANA_BOMB_EFFECT = MOB_EFFECTS.register("mana_bomb", () -> new InstantManaMobEffect(MobEffectCategory.HARMFUL, 8522336));
        REPLENISHMENT_EFFECT = MOB_EFFECTS.register("replenishment", () -> new ManaMobEffect(MobEffectCategory.BENEFICIAL, 10360765));
        LEAKING_MOB_EFFECT = MOB_EFFECTS.register("leaking", () -> new ManaMobEffect(MobEffectCategory.HARMFUL, 4120163));
        MANA_BOOST_EFFECT = MOB_EFFECTS.register("mana_boost", () -> new SimpleEffect(MobEffectCategory.BENEFICIAL, 5120179).m_19472_((Attribute)MAX_MANA_ATTRIBUTE.get(), "65CAA54F-F98E-4AA0-99F1-B4AC438C6DB8", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EXTRA_MANA_EFFECT = MOB_EFFECTS.register("extra_mana", () -> new ExtraManaMobEffect(MobEffectCategory.BENEFICIAL, 4085222));
        SILENCE_EFFECT = MOB_EFFECTS.register("silence", () -> new SimpleEffect(MobEffectCategory.HARMFUL, 7890484));
        MAGIC_IMMUNE_EFFECT = MOB_EFFECTS.register("magic_immune", () -> new SimpleEffect(MobEffectCategory.BENEFICIAL, 16762422));
        INSTANT_MANA = POTIONS.register("instant_mana", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)INSTANT_MANA_EFFECT.get(), 1)}));
        STRONG_INSTANT_MANA = POTIONS.register("strong_instant_mana", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)INSTANT_MANA_EFFECT.get(), 1, 1)}));
        MANA_BOMB = POTIONS.register("mana_bomb", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)MANA_BOMB_EFFECT.get(), 1)}));
        STRONG_MANA_BOMB = POTIONS.register("strong_mana_bomb", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)MANA_BOMB_EFFECT.get(), 1, 1)}));
        REPLENISHMENT = POTIONS.register("replenishment", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)REPLENISHMENT_EFFECT.get(), 900)}));
        LONG_REPLENISHMENT = POTIONS.register("long_replenishment", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)REPLENISHMENT_EFFECT.get(), 1800)}));
        STRONG_REPLENISHMENT = POTIONS.register("strong_replenishment", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)REPLENISHMENT_EFFECT.get(), 450, 1)}));
        LEAKING = POTIONS.register("leaking", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)LEAKING_MOB_EFFECT.get(), 900)}));
        LONG_LEAKING = POTIONS.register("long_leaking", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)LEAKING_MOB_EFFECT.get(), 1800)}));
        STRONG_LEAKING = POTIONS.register("strong_leaking", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)LEAKING_MOB_EFFECT.get(), 432, 1)}));
        SPELL_PROGRESSION_MENU = CONTAINER_TYPES.register("spell_progression", () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)SpellProgressionMenu::construct)));
        SPELL_PROJECTILE = ENTITY_TYPES.register("spell_projectile", () -> EntityType.Builder.m_20704_(SpellProjectile::new, (MobCategory)MobCategory.MISC).m_20702_(20).m_20717_(10).setShouldReceiveVelocityUpdates(true).m_20699_(0.5f, 0.5f).m_20712_("spell_projectile"));
        HOMING_SPELL_PROJECTILE = ENTITY_TYPES.register("homing_spell_projectile", () -> EntityType.Builder.m_20704_(HomingSpellProjectile::new, (MobCategory)MobCategory.MISC).m_20702_(20).m_20717_(2).setShouldReceiveVelocityUpdates(true).m_20699_(0.5f, 0.5f).m_20712_("homing_spell_projectile"));
    }
}

