/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import de.cas_ual_ty.spells.capability.ISpellDataHolder;
import de.cas_ual_ty.spells.capability.SpellsCapabilities;
import de.cas_ual_ty.spells.spelldata.ISpellDataType;
import de.cas_ual_ty.spells.spelldata.ITickedSpellData;
import de.cas_ual_ty.spells.spelldata.SpellData;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.LazyOptional;

public class SpellDataHolder
implements ISpellDataHolder {
    protected LivingEntity entity;
    protected List<SpellData> list;

    public SpellDataHolder(LivingEntity entity) {
        this.entity = entity;
        this.list = new LinkedList<SpellData>();
    }

    @Override
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public void tick() {
        this.list.stream().filter(d -> d instanceof ITickedSpellData).map(d -> (ITickedSpellData)((Object)d)).filter(d -> d.tickOnClient() || !this.entity.f_19853_.f_46443_).forEach(d -> d.tick(this));
        LinkedList<SpellData> newList = new LinkedList<SpellData>();
        this.list.stream().filter(d -> !d.shouldRemove(this)).forEach(newList::add);
        this.list = newList;
    }

    @Override
    public void add(SpellData data) {
        this.list.add(data);
    }

    @Override
    public void remove(SpellData spellData) {
        this.list.remove(spellData);
    }

    @Override
    public void removeAllOfType(ISpellDataType<?> type) {
        this.list.removeIf(data -> data.type == type);
    }

    @Override
    public boolean hasOfType(ISpellDataType<?> type) {
        return this.list.stream().anyMatch(data -> data.type == type);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public List<SpellData> getList() {
        return this.list;
    }

    @Override
    public <D extends SpellData> List<D> getAllOfType(ISpellDataType<D> type) {
        LinkedList list = new LinkedList();
        this.forEachOfType(type, list::add);
        return list;
    }

    @Override
    public <D extends SpellData> void forEachOfType(ISpellDataType<D> type, Consumer<D> consumer) {
        this.list.stream().filter(data -> data.type == type).map(data -> data).forEach(consumer);
    }

    public ListTag serializeNBT() {
        ListTag tag = new ListTag();
        this.list.stream().map(ISpellDataType::serialize).forEach(arg_0 -> tag.add(arg_0));
        return tag;
    }

    public void deserializeNBT(ListTag nbt) {
        this.list.clear();
        nbt.stream().filter(tag -> tag instanceof CompoundTag).map(t -> ISpellDataType.deserialize((CompoundTag)t)).filter(Objects::nonNull).forEach(this.list::add);
    }

    public static LazyOptional<SpellDataHolder> getSpellDataHolder(LivingEntity entity) {
        return entity.getCapability(SpellsCapabilities.SPELL_DATA_CAPABILITY).cast();
    }
}

