/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client;

import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.client.SpellsClientUtil;
import de.cas_ual_ty.spells.client.progression.SpellProgressionScreen;
import de.cas_ual_ty.spells.network.FireClientSpellMessage;
import de.cas_ual_ty.spells.network.ManaSyncMessage;
import de.cas_ual_ty.spells.network.SpellProgressionSyncMessage;
import de.cas_ual_ty.spells.network.SpellsSyncMessage;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ClientMessageHandler {
    public static void handleManaSync(ManaSyncMessage msg) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(msg.entityId())) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ManaHolder.getManaHolder(livingEntity).ifPresent(manaHolder -> {
                if (manaHolder.changeTime == -1) {
                    manaHolder.setMana(msg.mana());
                    manaHolder.setExtraMana(msg.extraMana());
                    manaHolder.changeTime = 0;
                } else {
                    manaHolder.setMana(msg.mana());
                    manaHolder.setExtraMana(msg.extraMana());
                }
            });
        }
    }

    public static void handleSpellsSync(SpellsSyncMessage msg) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(msg.entityId())) instanceof Player) {
            Player player = (Player)entity;
            SpellHolder.getSpellHolder(player).ifPresent(spellHolder -> {
                for (int i = 0; i < spellHolder.getSlots() && i < msg.spells().length; ++i) {
                    spellHolder.setSpell(i, msg.spells()[i]);
                }
            });
        }
    }

    public static void handleSpellProgressionSync(SpellProgressionSyncMessage msg) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof SpellProgressionScreen) {
            SpellProgressionScreen screen2 = (SpellProgressionScreen)screen;
            ((SpellProgressionMenu)screen2.m_6262_()).spellTrees = msg.spellTrees();
            ((SpellProgressionMenu)screen2.m_6262_()).spellProgression = msg.map();
            screen2.spellTreesUpdated();
        }
    }

    public static void handleFireSpell(FireClientSpellMessage msg) {
        SpellsClientUtil.getClientManaHolder().ifPresent(manaHolder -> msg.spell().performOnClient((ManaHolder)manaHolder));
    }
}

