/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.client.SpellsClientConfig;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ManaRenderer
implements IGuiOverlay {
    public static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("spells_and_shields", "textures/gui/spells_icons.png");
    protected Minecraft minecraft;
    protected final Random random = new Random();
    protected int lastMana;
    protected int displayMana;
    protected long lastManaTime;
    protected long manaBlinkTime;
    protected long lastManaChangeTime;
    protected final boolean above;
    protected final boolean right;

    public ManaRenderer(boolean above, boolean right) {
        this.minecraft = Minecraft.m_91087_();
        this.above = above;
        this.right = right;
    }

    public void render(ForgeGui gui, PoseStack mStack, float partialTicks, int width, int height) {
        if (this.above == (Boolean)SpellsClientConfig.MANA_ABOVE_FOOD.get() && this.right == ((Boolean)SpellsClientConfig.MANA_BY_HEALTH.get() == false) && !Minecraft.m_91087_().f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            this.renderMana(gui, width, height, mStack);
        }
    }

    public void renderMana(ForgeGui gui, int width, int height, PoseStack pStack) {
        Entity entity = this.minecraft.m_91288_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ManaHolder.getManaHolder((LivingEntity)player).ifPresent(manaHolder -> {
                boolean highlight;
                RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_ICONS_LOCATION);
                RenderSystem.m_69478_();
                float maxMana = manaHolder.getMaxMana();
                if (maxMana <= 0.0f) {
                    return;
                }
                int mana = Mth.m_14167_((float)manaHolder.getMana());
                if (manaHolder.getMana() >= maxMana) {
                    int hideManaTime;
                    if (mana != this.lastMana) {
                        this.lastManaChangeTime = Util.m_137550_();
                    }
                    if ((hideManaTime = ((Integer)SpellsClientConfig.MANA_HIDE_DELAY.get()).intValue()) != 0 && UnitType.forPlayer(player) == UnitType.NORMAL && Util.m_137550_() - this.lastManaChangeTime >= (long)hideManaTime * 50L) {
                        return;
                    }
                }
                boolean bl = highlight = this.manaBlinkTime > (long)gui.m_93079_() && (this.manaBlinkTime - (long)gui.m_93079_()) / 3L % 2L == 1L;
                if (mana < this.lastMana && manaHolder.changeTime > 0) {
                    this.lastManaTime = Util.m_137550_();
                    this.manaBlinkTime = gui.m_93079_() + 20;
                } else if (mana > this.lastMana && manaHolder.changeTime > 0) {
                    this.lastManaTime = Util.m_137550_();
                    this.manaBlinkTime = gui.m_93079_() + 10;
                }
                if (Util.m_137550_() - this.lastManaTime > 1000L) {
                    this.lastMana = mana;
                    this.displayMana = mana;
                    this.lastManaTime = Util.m_137550_();
                }
                this.lastMana = mana;
                int manaLast = this.displayMana;
                float manaMax = Math.max(maxMana, (float)Math.max(manaLast, mana));
                int extra = Mth.m_14167_((float)manaHolder.getExtraMana());
                int rows = Mth.m_14167_((float)((manaMax + (float)extra) / 2.0f / 10.0f));
                int rowHeight = Math.max(10 - (rows - 2), 3);
                this.random.setSeed((long)gui.m_93079_() * 27L);
                int left = this.right ? width / 2 + 10 : width / 2 - 91;
                int top = height - (this.right ? gui.rightHeight : gui.leftHeight);
                if (!this.right && this.above && player.m_21230_() <= 0) {
                    top += 10;
                }
                int regen = -1;
                if (player.m_21023_((MobEffect)SpellsRegistries.REPLENISHMENT_EFFECT.get())) {
                    regen = gui.m_93079_() % Mth.m_14167_((float)(manaMax + 5.0f));
                }
                this.renderUnit(gui, pStack, player, left, top, rowHeight, regen, manaMax, mana, manaLast, extra, highlight);
                int change = rows * rowHeight + (rowHeight != 10 ? 10 - rowHeight : 0);
                if (this.right) {
                    gui.rightHeight += change;
                } else {
                    gui.leftHeight += change;
                }
                RenderSystem.m_69461_();
            });
        }
    }

    protected void renderUnit(ForgeGui gui, PoseStack poseStack, Player player, int left, int top, int rowHeight, int regen, float manaMax, int mana, int manaLast, int extra, boolean highlight) {
        UnitType unitType = UnitType.forPlayer(player);
        int v = 0;
        int totalUnits = Mth.m_14165_((double)((double)manaMax / 2.0));
        int totalExtraUnits = Mth.m_14165_((double)((double)extra / 2.0));
        int manaCeil = totalUnits * 2;
        for (int idx = totalUnits + totalExtraUnits - 1; idx >= 0; --idx) {
            boolean half;
            int i;
            boolean renderExtra;
            int row = idx / 10;
            int column = idx % 10;
            int x = left + column * 8;
            int y = top - row * rowHeight;
            if (((Boolean)SpellsClientConfig.MANA_JITTER.get()).booleanValue() && mana + extra <= 4) {
                y += this.random.nextInt(2);
            }
            if (idx < totalUnits && idx == regen) {
                y -= 2;
            }
            this.renderUnit(gui, poseStack, UnitType.CONTAINER, x, y, v, highlight, false);
            int idx2 = idx * 2;
            boolean bl = renderExtra = idx >= totalUnits;
            if (renderExtra && (i = idx2 - manaCeil) < extra) {
                boolean half2 = i + 1 == extra;
                this.renderUnit(gui, poseStack, UnitType.EXTRA, x, y, v, false, half2);
            }
            if (highlight && idx2 < manaLast) {
                half = idx2 + 1 == manaLast;
                this.renderUnit(gui, poseStack, unitType, x, y, v, true, half);
            }
            if (idx2 >= mana) continue;
            half = idx2 + 1 == mana;
            this.renderUnit(gui, poseStack, unitType, x, y, v, false, half);
        }
    }

    private void renderUnit(ForgeGui gui, PoseStack poseStack, UnitType unitType, int x, int y, int v, boolean highlight, boolean half) {
        gui.m_93228_(poseStack, x, y, unitType.getU(half, highlight), v, 9, 9);
    }

    private static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.FOOD_LEVEL.id(), "player_mana_above_hunger", (IGuiOverlay)new ManaRenderer(true, true));
        event.registerBelow(VanillaGuiOverlay.FOOD_LEVEL.id(), "player_mana_below_hunger", (IGuiOverlay)new ManaRenderer(true, false));
        event.registerAbove(VanillaGuiOverlay.PLAYER_HEALTH.id(), "player_mana_above_health", (IGuiOverlay)new ManaRenderer(false, true));
        event.registerBelow(VanillaGuiOverlay.PLAYER_HEALTH.id(), "player_mana_below_health", (IGuiOverlay)new ManaRenderer(false, false));
    }

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ManaRenderer::registerGuiOverlays);
    }

    public static enum UnitType {
        CONTAINER(0, false),
        NORMAL(2, true),
        DRAINED(4, true),
        EXTRA(6, false);

        private final int index;
        private final boolean whiteFlash;

        private UnitType(int index, boolean canBlink) {
            this.index = index;
            this.whiteFlash = canBlink;
        }

        public int getU(boolean half, boolean highlight) {
            int i = this == CONTAINER ? (highlight ? 1 : 0) : (half ? 1 : 0) + (this.whiteFlash && highlight ? 2 : 0);
            return (this.index * 2 + i) * 9;
        }

        static UnitType forPlayer(Player player) {
            if (player.m_21023_((MobEffect)SpellsRegistries.LEAKING_MOB_EFFECT.get())) {
                return DRAINED;
            }
            return NORMAL;
        }
    }
}

